/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public final class JoCodeRegistry {
    private static final Map<ResourceLocation, Map<Integer, List<JoCode>>> CODES = new HashMap<ResourceLocation, Map<Integer, List<JoCode>>>();

    private JoCodeRegistry() {
    }

    public static void clear() {
        CODES.clear();
    }

    public static void register(ResourceLocation speciesName, int radius, JoCode code) {
        CODES.computeIfAbsent(speciesName, s -> new HashMap()).computeIfAbsent(radius, r -> new ArrayList()).add(code);
    }

    public static Map<Integer, List<JoCode>> getCodes(ResourceLocation speciesName) {
        return Collections.unmodifiableMap(CODES.getOrDefault(speciesName, new HashMap()));
    }

    public static List<JoCode> getCodes(ResourceLocation speciesName, int radius) {
        return Collections.unmodifiableList(JoCodeRegistry.getCodes(speciesName).getOrDefault(radius, new ArrayList()));
    }

    @Nullable
    public static JoCode getRandomCode(ResourceLocation speciesName, int radius, Random random) {
        List<JoCode> list = JoCodeRegistry.getCodes(speciesName, radius);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(random.nextInt(list.size()));
    }
}

