/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.cells.LeafClusters;
import com.ferreusveritas.dynamictrees.compat.seasons.SeasonHelper;
import com.ferreusveritas.dynamictrees.data.DTBlockTags;
import com.ferreusveritas.dynamictrees.event.SpeciesPostGenerationEvent;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.nodemappers.CoderNode;
import com.ferreusveritas.dynamictrees.systems.nodemappers.CollectorNode;
import com.ferreusveritas.dynamictrees.systems.nodemappers.FindEndsNode;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.BlockStates;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import com.ferreusveritas.dynamictrees.util.WorldContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JoCode {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String BASE_64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    protected static final byte FORK_CODE = 6;
    protected static final byte RETURN_CODE = 7;
    public byte[] instructions = new byte[0];
    protected boolean careful = false;
    private final byte[][] dirmap = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 3, 2, 5, 4, 6, 7}, {0, 1, 5, 4, 2, 3, 6, 7}, {0, 1, 4, 5, 3, 2, 6, 7}};
    private byte[] facingMap = this.dirmap[2];
    private byte[] unfacingMap = this.dirmap[2];

    public JoCode(World world, BlockPos rootPos, Direction facing) {
        Optional<BranchBlock> branch = TreeHelper.getBranchOpt(world.func_180495_p(rootPos.func_177984_a()));
        if (branch.isPresent()) {
            CoderNode coder = new CoderNode();
            branch.get().analyse(world.func_180495_p(rootPos), (IWorld)world, rootPos, Direction.DOWN, new MapSignal(coder));
            this.instructions = coder.compile(this);
            this.rotate(facing);
        }
    }

    public JoCode(World world, BlockPos pos) {
        this(world, pos, Direction.SOUTH);
    }

    public JoCode(String code) {
        this.instructions = JoCode.decode(code);
    }

    public JoCode setCareful(boolean c) {
        this.careful = c;
        return this;
    }

    protected int getCode(int pos) {
        return this.unfacingMap[this.instructions[pos]];
    }

    public JoCode setFacing(Direction facing) {
        int faceNum = facing.ordinal();
        this.facingMap = this.dirmap[faceNum];
        faceNum = faceNum == 4 ? 5 : (faceNum == 5 ? 4 : faceNum);
        this.unfacingMap = this.dirmap[faceNum];
        return this;
    }

    public JoCode rotate(Direction dir) {
        this.setFacing(dir);
        for (int c = 0; c < this.instructions.length; ++c) {
            this.instructions[c] = this.facingMap[this.instructions[c]];
        }
        return this;
    }

    public void generate(WorldContext worldContext, Species species, BlockPos rootPosIn, Biome biome, Direction facing, int radius, SafeChunkBounds safeBounds, boolean secondChanceRegen) {
        BlockPos.Mutable cellPos;
        IWorld world = worldContext.access();
        boolean worldGen = safeBounds != SafeChunkBounds.ANY;
        radius = MathHelper.func_76125_a((int)radius, (int)2, (int)8);
        this.setFacing(facing);
        BlockPos rootPos = species.preGeneration(world, rootPosIn, radius, facing, safeBounds, this);
        if (rootPos == BlockPos.field_177992_a) {
            return;
        }
        BlockState initialDirtState = world.func_180495_p(rootPos);
        species.placeRootyDirtBlock(world, rootPos, 0);
        this.generateFork(world, species, 0, rootPos, false);
        BlockPos treePos = rootPos.func_177984_a();
        BlockState treeState = world.func_180495_p(treePos);
        BranchBlock firstBranch = TreeHelper.getBranch(treeState);
        if (firstBranch == null) {
            world.func_180501_a(rootPos, initialDirtState, this.careful ? 3 : 2);
            return;
        }
        LeavesProperties leavesProperties = species.getLeavesProperties();
        SimpleVoxmap leafMap = new SimpleVoxmap(radius * 2 + 1, species.getWorldGenLeafMapHeight(), radius * 2 + 1).setMapAndCenter(treePos, new BlockPos(radius, 0, radius));
        NodeInspector inflator = species.getNodeInflator(leafMap);
        FindEndsNode endFinder = new FindEndsNode();
        MapSignal signal = new MapSignal(inflator, endFinder);
        signal.destroyLoopedNodes = this.careful;
        firstBranch.analyse(treeState, world, treePos, Direction.DOWN, signal);
        if (signal.foundRoot || signal.overflow) {
            this.tryGenerateAgain(worldContext, species, rootPosIn, biome, facing, radius, safeBounds, worldGen, treePos, treeState, endFinder, secondChanceRegen);
            return;
        }
        List<BlockPos> endPoints = endFinder.getEnds();
        this.smother(leafMap, leavesProperties);
        for (SimpleVoxmap.Cell cell : leafMap.getAllNonZeroCells((byte)15)) {
            cellPos = cell.getPos();
            if (safeBounds.inBounds((BlockPos)cellPos, false)) {
                BlockState testBlockState = world.func_180495_p((BlockPos)cellPos);
                if (!testBlockState.canBeReplacedByLeaves((IWorldReader)world, (BlockPos)cellPos)) continue;
                world.func_180501_a((BlockPos)cellPos, leavesProperties.getDynamicLeavesState(cell.getValue()), worldGen ? 16 : 2);
                continue;
            }
            leafMap.setVoxel((BlockPos)cellPos, (byte)0);
        }
        for (SimpleVoxmap.Cell cell : leafMap.getAllNonZeroCells()) {
            cellPos = cell.getPos();
            if (safeBounds.inBounds((BlockPos)cellPos, true)) continue;
            leafMap.setVoxel((BlockPos)cellPos, (byte)0);
        }
        TreeHelper.ageVolume(world, leafMap, species.getWorldGenAgeIterations(), safeBounds);
        if (species.handleRot(world, endPoints, rootPos, treePos, 0, safeBounds)) {
            return;
        }
        species.postGeneration(new PostGenerationContext(world, rootPos, species, biome, radius, endPoints, safeBounds, initialDirtState, SeasonHelper.getSeasonValue(worldContext, rootPos), Float.valueOf(species.seasonalFruitProductionFactor(worldContext, rootPos))));
        MinecraftForge.EVENT_BUS.post((Event)new SpeciesPostGenerationEvent(world, species, rootPos, endPoints, safeBounds, initialDirtState));
        this.addSnow(leafMap, world, rootPos, biome);
    }

    private void tryGenerateAgain(WorldContext worldContext, Species species, BlockPos rootPosIn, Biome biome, Direction facing, int radius, SafeChunkBounds safeBounds, boolean worldGen, BlockPos treePos, BlockState treeState, FindEndsNode endFinder, boolean secondChanceRegen) {
        if (worldGen) {
            if (!secondChanceRegen) {
                LOGGER.debug("Non-viable branch network detected during world generation @ {}", (Object)treePos);
                LOGGER.debug("Species: {}", (Object)species);
                LOGGER.debug("Radius: {}", (Object)radius);
                LOGGER.debug("JoCode: {}", (Object)this);
            } else {
                LOGGER.debug("Second attempt for code {} has also failed", (Object)this);
            }
        }
        this.cleanupFrankentree(worldContext.access(), treePos, treeState, endFinder.getEnds(), safeBounds);
        if (!secondChanceRegen) {
            this.generate(worldContext, species, rootPosIn, biome, facing, radius, safeBounds, true);
        }
    }

    protected void cleanupFrankentree(IWorld world, BlockPos treePos, BlockState treeState, List<BlockPos> endPoints, SafeChunkBounds safeBounds) {
        HashSet<BlockPos> blocksToDestroy = new HashSet<BlockPos>();
        BranchBlock branch = TreeHelper.getBranch(treeState);
        MapSignal signal = new MapSignal(new CollectorNode(blocksToDestroy));
        signal.destroyLoopedNodes = false;
        signal.trackVisited = true;
        assert (branch != null);
        branch.analyse(treeState, world, treePos, null, signal);
        BranchBlock.destroyMode = DynamicTrees.DestroyMode.IGNORE;
        for (BlockPos pos : blocksToDestroy) {
            BlockState branchState;
            Optional<BranchBlock> branchBlock;
            if (!safeBounds.inBounds(pos, false) || !(branchBlock = TreeHelper.getBranchOpt(branchState = world.func_180495_p(pos))).isPresent()) continue;
            int radius = branchBlock.get().getRadius(branchState);
            Family family = branchBlock.get().getFamily();
            Species species = family.getCommonSpecies();
            if (family.getPrimaryThickness() == radius) {
                species.getLeavesProperties().ifValid(leavesProperties -> {
                    SimpleVoxmap leafCluster = leavesProperties.getCellKit().getLeafCluster();
                    if (leafCluster != LeafClusters.NULL_MAP) {
                        for (SimpleVoxmap.Cell cell : leafCluster.getAllNonZeroCells()) {
                            BlockState leavesState;
                            BlockPos delPos = pos.func_177971_a((Vector3i)cell.getPos());
                            if (!safeBounds.inBounds(delPos, false) || !TreeHelper.isLeaves(leavesState = world.func_180495_p(delPos))) continue;
                            DynamicLeavesBlock leavesBlock = (DynamicLeavesBlock)leavesState.func_177230_c();
                            if (leavesProperties.getFamily() != leavesBlock.getProperties(leavesState).getFamily()) continue;
                            world.func_180501_a(delPos, BlockStates.AIR, 2);
                        }
                    }
                });
            }
            world.func_180501_a(pos, BlockStates.AIR, 2);
        }
        BranchBlock.destroyMode = DynamicTrees.DestroyMode.HARVEST;
    }

    protected int generateFork(IWorld world, Species species, int codePos, BlockPos pos, boolean disabled) {
        block4: while (codePos < this.instructions.length) {
            int code = this.getCode(codePos);
            switch (code) {
                case 6: {
                    codePos = this.generateFork(world, species, codePos + 1, pos, disabled);
                    continue block4;
                }
                case 7: {
                    return codePos + 1;
                }
            }
            Direction dir = Direction.func_82600_a((int)code);
            pos = pos.func_177972_a(dir);
            if (!disabled) {
                disabled = this.setBlockForGeneration(world, species, pos, dir, this.careful, codePos + 1 == this.instructions.length);
            }
            ++codePos;
        }
        return codePos;
    }

    protected boolean setBlockForGeneration(IWorld world, Species species, BlockPos pos, Direction dir, boolean careful, boolean isLast) {
        BlockState state = world.func_180495_p(pos);
        if ((state.canBeReplacedByLogs((IWorldReader)world, pos) && !state.func_177230_c().func_203417_a((ITag)BlockTags.field_200031_h) || state.func_185904_a().func_76224_d() || state.func_177230_c().func_203417_a(DTBlockTags.FOLIAGE) || state.func_177230_c().func_203417_a((ITag)BlockTags.field_226149_I_)) && (!careful || this.isClearOfNearbyBranches(world, pos, dir.func_176734_d()))) {
            species.getFamily().getBranchForPlacement(world, species, pos).ifPresent(branch -> branch.setRadius(world, pos, species.getFamily().getPrimaryThickness(), null, careful ? 3 : 2));
            return false;
        }
        return true;
    }

    protected void smother(SimpleVoxmap leafMap, LeavesProperties leavesProperties) {
        int smotherMax = leavesProperties.getSmotherLeavesMax();
        if (smotherMax == 0) {
            return;
        }
        BlockPos saveCenter = leafMap.getCenter();
        leafMap.setCenter(new BlockPos(0, 0, 0));
        for (int startY = leafMap.getLenY() - 1; startY >= 0 && !leafMap.isYTouched(startY); --startY) {
        }
        for (int iz = 0; iz < leafMap.getLenZ(); ++iz) {
            for (int ix = 0; ix < leafMap.getLenX(); ++ix) {
                int count = 0;
                for (int iy = startY; iy >= 0; --iy) {
                    byte v = leafMap.getVoxel(new BlockPos(ix, iy, iz));
                    if (v == 0) {
                        count = 0;
                        continue;
                    }
                    if ((v & 0xF) != 0) {
                        if (++count <= smotherMax) continue;
                        leafMap.setVoxel(new BlockPos(ix, iy, iz), (byte)0);
                        continue;
                    }
                    if ((v & 0x10) == 0) continue;
                    ++count;
                    leafMap.setVoxel(new BlockPos(ix, iy + 1, iz), (byte)4);
                }
            }
        }
        leafMap.setCenter(saveCenter);
    }

    protected boolean isClearOfNearbyBranches(IWorld world, BlockPos pos, Direction except) {
        for (Direction dir : Direction.values()) {
            if (dir == except || TreeHelper.getBranch(world.func_180495_p(pos.func_177972_a(dir))) == null) continue;
            return false;
        }
        return true;
    }

    protected void addSnow(SimpleVoxmap leafMap, IWorld world, BlockPos rootPos, Biome biome) {
        if (biome.func_242445_k() >= 0.4f) {
            return;
        }
        block0: for (BlockPos.Mutable top : leafMap.getTops()) {
            if (!world.func_225604_a_(rootPos.func_177958_n() >> 2, rootPos.func_177956_o() >> 2, rootPos.func_177952_p() >> 2).func_201850_b((IWorldReader)world, rootPos)) continue;
            BlockPos.Mutable iPos = new BlockPos.Mutable(top.func_177958_n(), top.func_177956_o(), top.func_177952_p());
            int yOffset = 0;
            do {
                BlockState state;
                if ((state = world.func_180495_p((BlockPos)iPos)).func_185904_a() == Material.field_151579_a) {
                    world.func_180501_a((BlockPos)iPos, Blocks.field_150433_aE.func_176223_P(), 2);
                    continue block0;
                }
                if (state.func_177230_c() == Blocks.field_150433_aE) continue block0;
                iPos.func_185336_p(iPos.func_177956_o() + 1);
            } while (yOffset++ < 4);
        }
    }

    public static String encode(byte[] array) {
        ArrayList<Byte> instructions = new ArrayList<Byte>(array.length + (array.length & 1));
        for (byte b : array) {
            instructions.add(b);
        }
        if ((instructions.size() & 1) == 1) {
            instructions.add((byte)7);
        }
        StringBuilder code = new StringBuilder();
        for (int b = 0; b < instructions.size(); b += 2) {
            code.append(BASE_64.charAt((Byte)instructions.get(b) << 3 | (Byte)instructions.get(b + 1)));
        }
        return code.toString();
    }

    public static byte[] decode(String code) {
        return new CodeCompiler(code).compile();
    }

    public String toString() {
        return JoCode.encode(this.instructions);
    }

    public ITextComponent getTextComponent() {
        return new StringTextComponent(this.toString()).func_240700_a_(style -> style.func_240712_a_(TextFormatting.AQUA).func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, this.toString())).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("chat.copy.click"))));
    }

    public static class CodeCompiler {
        final ArrayList<Byte> instructions;

        public CodeCompiler() {
            this.instructions = new ArrayList();
        }

        public CodeCompiler(int size) {
            this.instructions = new ArrayList(size);
        }

        public CodeCompiler(String code) {
            this.instructions = new ArrayList(code.length() * 2);
            for (int i = 0; i < code.length(); ++i) {
                int sixbits = JoCode.BASE_64.indexOf(code.charAt(i));
                if (sixbits == -1) continue;
                this.addInstruction((byte)(sixbits >> 3));
                this.addInstruction((byte)(sixbits & 7));
            }
        }

        public void addDirection(byte dir) {
            if (dir >= 0) {
                this.instructions.add((byte)(dir & 7));
            }
        }

        public void addInstruction(byte instruction) {
            this.instructions.add(instruction);
        }

        public void addReturn() {
            this.instructions.add((byte)7);
        }

        public void addFork() {
            this.instructions.add((byte)6);
        }

        public byte[] compile() {
            byte[] array = new byte[this.instructions.size()];
            Iterator<Byte> i = this.instructions.iterator();
            int pos = 0;
            while (i.hasNext()) {
                array[pos++] = i.next();
            }
            return array;
        }
    }
}

