/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.systems.poissondisc.PoissonDisc;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.WorldContext;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDatabase;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDatabases;
import com.ferreusveritas.dynamictrees.worldgen.TreeGenerator;
import java.util.Random;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public final class DynamicTreeFeature
extends Feature<NoFeatureConfig> {
    public DynamicTreeFeature() {
        super(NoFeatureConfig.field_236558_a_);
        this.setRegistryName(new ResourceLocation("dynamictrees", "tree"));
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        TreeGenerator treeGenerator = TreeGenerator.getTreeGenerator();
        ResourceLocation dimensionName = world.func_201672_e().func_234923_W_().func_240901_a_();
        if (BiomeDatabases.isBlacklisted(dimensionName)) {
            return false;
        }
        BiomeDatabase biomeDatabase = BiomeDatabases.getDimensionalOrDefault(dimensionName);
        ChunkPos chunkPos = world.func_217349_x(pos).func_76632_l();
        SafeChunkBounds chunkBounds = SafeChunkBounds.ANY_WG;
        WorldContext worldContext = new WorldContext((RegistryKey<World>)world.func_201672_e().func_234923_W_(), world.func_72905_C(), (IWorld)world, (World)world.func_201672_e());
        treeGenerator.getCircleProvider().getPoissonDiscs(worldContext, chunkPos).forEach(disc -> treeGenerator.makeTrees(worldContext, biomeDatabase, (PoissonDisc)disc, chunkBounds));
        return true;
    }
}

