/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public final class WorldContext {
    private final RegistryKey<World> dimensionKey;
    private final ResourceLocation dimensionName;
    @Nullable
    private final Long seed;
    private final IWorld access;
    private final World level;

    public WorldContext(RegistryKey<World> dimensionKey, @Nullable Long seed, IWorld acess, World level) {
        this.dimensionKey = dimensionKey;
        this.dimensionName = dimensionKey.func_240901_a_();
        this.seed = seed;
        this.access = acess;
        this.level = level;
    }

    public RegistryKey<World> dimensionKey() {
        return this.dimensionKey;
    }

    public ResourceLocation dimensionName() {
        return this.dimensionName;
    }

    @Nullable
    public Long seed() {
        return this.seed;
    }

    public IWorld access() {
        return this.access;
    }

    public World level() {
        return this.level;
    }

    public static WorldContext create(IWorld access) {
        World level = null;
        Long seed = null;
        if (access instanceof World) {
            level = (World)access;
        } else if (access instanceof IServerWorld) {
            level = ((IServerWorld)access).func_201672_e();
        }
        if (level == null) {
            throw new RuntimeException("Could not handle custom IWorld object: " + access.getClass());
        }
        if (access instanceof ISeedReader) {
            seed = ((ISeedReader)access).func_72905_C();
        }
        return new WorldContext((RegistryKey<World>)level.func_234923_W_(), seed, access, level);
    }

    public static ServerWorld getServerWorldOrThrow(IWorld access) {
        if (access instanceof ServerWorld) {
            return (ServerWorld)access;
        }
        if (access instanceof IServerWorld) {
            return ((IServerWorld)access).func_201672_e();
        }
        throw new IllegalArgumentException("Cannot get ServerWorld from IWorld of type: " + access.getClass());
    }
}

