/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import javax.annotation.Nullable;
import net.minecraft.util.math.MathHelper;

public class SimpleBitmap {
    private final int height;
    private final int width;
    private int[] bits;
    public boolean touched;

    public SimpleBitmap(int width, int height) {
        this.width = MathHelper.func_76125_a((int)width, (int)1, (int)32);
        this.height = Math.max(1, height);
        this.bits = new int[this.height];
        this.touched = false;
    }

    public SimpleBitmap(int width, int height, @Nullable int[] bits) {
        this(width, height);
        int size;
        if (bits != null && (size = Math.min(bits.length, this.height)) >= 0) {
            System.arraycopy(bits, 0, this.bits, 0, size);
        }
        this.touched = true;
    }

    public SimpleBitmap(SimpleBitmap bmp) {
        this(bmp.width, bmp.height);
        System.arraycopy(bmp.bits, 0, this.bits, 0, this.bits.length);
        this.touched = bmp.touched;
    }

    public int[] getBits() {
        return this.bits;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public SimpleBitmap clear() {
        this.bits = new int[this.height];
        this.touched = false;
        return this;
    }

    public boolean isColliding(int relX, int relY, SimpleBitmap src) {
        BlitPreparationResult result = this.prepBlit(relX, relY, src);
        if (!result.success) {
            return false;
        }
        if (relX < 0) {
            relX = -relX;
            while (result.runH-- > 0) {
                if ((this.bits[result.dstOffsetY++] << relX & src.getBits()[result.srcOffsetY++]) == 0) continue;
                return true;
            }
        } else {
            while (result.runH-- > 0) {
                if ((this.bits[result.dstOffsetY++] & src.getBits()[result.srcOffsetY++] << relX) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public void blitOr(int relX, int relY, SimpleBitmap src) {
        BlitPreparationResult result = this.prepBlit(relX, relY, src);
        if (!result.success) {
            return;
        }
        if (relX < 0) {
            relX = -relX;
            while (result.runH-- > 0) {
                int n = result.dstOffsetY++;
                this.bits[n] = this.bits[n] | src.getBits()[result.srcOffsetY++] >>> relX;
            }
        } else {
            while (result.runH-- > 0) {
                int n = result.dstOffsetY++;
                this.bits[n] = this.bits[n] | src.getBits()[result.srcOffsetY++] << relX;
            }
        }
        this.touched = true;
    }

    public void blitSub(int relX, int relY, SimpleBitmap src) {
        BlitPreparationResult result = this.prepBlit(relX, relY, src);
        if (!result.success) {
            return;
        }
        if (relX < 0) {
            relX = -relX;
            while (result.runH-- > 0) {
                int n = result.dstOffsetY++;
                this.bits[n] = this.bits[n] & ~(src.getBits()[result.srcOffsetY++] >>> relX);
            }
        } else {
            while (result.runH-- > 0) {
                int n = result.dstOffsetY++;
                this.bits[n] = this.bits[n] & ~(src.getBits()[result.srcOffsetY++] << relX);
            }
        }
        this.touched = true;
    }

    public void blitAnd(int relX, int relY, SimpleBitmap src) {
        BlitPreparationResult result = this.prepBlit(relX, relY, src);
        if (!result.success) {
            return;
        }
        if (relX < 0) {
            relX = -relX;
            while (result.runH-- > 0) {
                int n = result.dstOffsetY++;
                this.bits[n] = this.bits[n] & src.getBits()[result.srcOffsetY++] >>> relX;
            }
        } else {
            while (result.runH-- > 0) {
                int n = result.dstOffsetY++;
                this.bits[n] = this.bits[n] & ~(src.getBits()[result.srcOffsetY++] << relX);
            }
        }
        this.touched = true;
    }

    private BlitPreparationResult prepBlit(int relX, int relY, SimpleBitmap src) {
        int srcOffsetY;
        int dstOffsetY;
        if (relX <= -src.width || relX >= this.width || relY <= -src.height || relY >= this.height || !this.touched && !src.touched) {
            return BlitPreparationResult.failure();
        }
        if (relY >= 0) {
            dstOffsetY = relY;
            srcOffsetY = 0;
        } else {
            dstOffsetY = 0;
            srcOffsetY = -relY;
        }
        int runH = Math.min(this.height - dstOffsetY, Math.min(src.height, this.height - relY) - srcOffsetY);
        return BlitPreparationResult.success(dstOffsetY, srcOffsetY, runH);
    }

    public void setPixel(int x, int y, int mode) {
        if (x >= 0 && y >= 0 && x < this.width && y < this.height) {
            this.bits[y] = this.bits[y] & ~((mode &= 1) << x) | mode << x;
            this.touched = true;
        }
    }

    public boolean isPixelOn(int x, int y) {
        return x >= 0 && y >= 0 && x < this.width && y < this.height && (this.bits[y] >> x & 1) == 1;
    }

    public boolean isRowBlank(int y) {
        return y >= 0 && y < this.height && this.bits[y] == 0;
    }

    public void print() {
        for (int y = 0; y < this.height; ++y) {
            StringBuilder buff = new StringBuilder();
            for (int x = 0; x < this.width; ++x) {
                buff.append(this.isPixelOn(x, y) ? "\u2588" : "\u2591");
            }
            System.out.println(buff);
        }
    }

    private static final class BlitPreparationResult {
        private static final BlitPreparationResult FAILURE = new BlitPreparationResult(false, 0, 0, 0);
        private final boolean success;
        private int dstOffsetY;
        private int srcOffsetY;
        private int runH;

        public BlitPreparationResult(boolean success, int dstOffsetY, int srcOffsetY, int runH) {
            this.success = success;
            this.dstOffsetY = dstOffsetY;
            this.srcOffsetY = srcOffsetY;
            this.runH = runH;
        }

        private static BlitPreparationResult failure() {
            return FAILURE;
        }

        private static BlitPreparationResult success(int dstOffsetY, int srcOffsetY, int runH) {
            return new BlitPreparationResult(true, dstOffsetY, srcOffsetY, runH);
        }
    }
}

