/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.ChunkStatus;

@Deprecated
public class SafeChunkBounds {
    public static final SafeChunkBounds ANY = new SafeChunkBounds(){

        @Override
        public boolean inBounds(BlockPos pos, boolean gap) {
            return true;
        }
    };
    public static final SafeChunkBounds ANY_WG = new SafeChunkBounds(){

        @Override
        public boolean inBounds(BlockPos pos, boolean gap) {
            return true;
        }
    };
    protected static final Tile[] TILES = new Tile[16];
    private final ChunkPos center;
    private final BlockBounds[] chunkBounds = new BlockBounds[16];

    protected SafeChunkBounds() {
        this.center = null;
    }

    public SafeChunkBounds(ISeedReader world, ChunkPos pos) {
        this.center = pos;
        for (Tile tile : TILES) {
            ChunkPos cp = new ChunkPos(pos.field_77276_a + tile.pos.field_77276_a, pos.field_77275_b + tile.pos.field_77275_b);
            boolean loaded = world.func_72863_F().func_212849_a_(cp.field_77276_a, cp.field_77275_b, ChunkStatus.field_223226_a_, false) != null;
            this.chunkBounds[tile.index] = loaded ? new BlockBounds(cp) : BlockBounds.INVALID;
        }
        for (Tile tile : TILES) {
            BlockBounds curr = this.chunkBounds[tile.index];
            if (curr == BlockBounds.INVALID) continue;
            for (Direction dir : CoordUtils.HORIZONTALS) {
                boolean validDir = false;
                if ((tile.borders & 1 << dir.func_176745_a()) != 0) {
                    BlockBounds adjTile = this.chunkBounds[tile.index + dir.func_82601_c() + dir.func_82599_e() * 4];
                    boolean bl = validDir = adjTile != BlockBounds.INVALID;
                }
                if (validDir) continue;
                curr.shrink(dir, 1);
            }
        }
    }

    public boolean inBounds(BlockPos pos, boolean gap) {
        int chunkZ;
        int tileZ;
        int chunkX = pos.func_177958_n() >> 4;
        int tileX = chunkX - this.center.field_77276_a + 1;
        if (((tileX | (tileZ = (chunkZ = pos.func_177952_p() >> 4) - this.center.field_77275_b + 1)) & 0xFFFFFFFC) == 0) {
            int index = tileX + tileZ * 4;
            return !gap && this.chunkBounds[index] != BlockBounds.INVALID || this.chunkBounds[index].inBounds(pos);
        }
        return false;
    }

    public boolean inBounds(BlockBounds bounds, boolean gap) {
        BlockPos min = bounds.getMin();
        BlockPos max = bounds.getMax();
        return this.inBounds(min, gap) && this.inBounds(max, gap) && this.inBounds(new BlockPos(min.func_177958_n(), 0, max.func_177952_p()), gap) && this.inBounds(new BlockPos(max.func_177958_n(), 0, min.func_177952_p()), gap);
    }

    public void setBlockState(IWorld world, BlockPos pos, BlockState state, boolean gap) {
        this.setBlockState(world, pos, state, 3, gap);
    }

    public void setBlockState(IWorld world, BlockPos pos, BlockState state, int flags, boolean gap) {
        if (this.inBounds(pos, gap)) {
            world.func_180501_a(pos, state, flags);
        }
    }

    static {
        for (int z = 0; z < 4; ++z) {
            for (int x = 0; x < 4; ++x) {
                int index = z * 4 + x;
                SafeChunkBounds.TILES[index] = new Tile(index, new ChunkPos(x - 1, z - 1), (z != 0 ? 4 : 0) | (z != 3 ? 8 : 0) | (x != 0 ? 16 : 0) | (x != 3 ? 32 : 0));
            }
        }
    }

    protected static class Tile {
        public final ChunkPos pos;
        public final int borders;
        public final int index;

        public Tile(int index, ChunkPos pos, int borderFlags) {
            this.index = index;
            this.pos = pos;
            this.borders = borderFlags;
        }
    }
}

