/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.util.ResourceLocation;

public final class LootTableSupplier {
    private final String path;
    private final ResourceLocation name;
    private final ResourceLocation baseName;

    public LootTableSupplier(String basePath, ResourceLocation name) {
        this.path = basePath;
        this.name = name;
        this.baseName = ResourceLocationUtils.prefix(name, this.path);
    }

    public LootTable get(LootTableManager lootTableManager, Species species) {
        LootTable speciesOverrideTable = lootTableManager.func_186521_a(this.getName(species));
        if (speciesOverrideTable != LootTable.field_186464_a) {
            return speciesOverrideTable;
        }
        return lootTableManager.func_186521_a(this.baseName);
    }

    public ResourceLocation getName(Species species) {
        ResourceLocation speciesName = species.getRegistryName();
        return ResourceLocationUtils.surround(this.name, this.path, "/" + speciesName.func_110624_b() + "/" + speciesName.func_110623_a());
    }

    public ResourceLocation getName() {
        return this.baseName;
    }
}

