/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.blocks.FruitBlock;
import com.ferreusveritas.dynamictrees.blocks.PodBlock;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.branches.SurfaceRootBlock;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.RootyBlock;
import com.ferreusveritas.dynamictrees.entities.FallingTreeEntity;
import com.ferreusveritas.dynamictrees.systems.nodemappers.CollectorNode;
import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.ferreusveritas.dynamictrees.util.BlockStates;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;

public class ChunkTreeHelper {
    private static final int CHUNK_WIDTH = 16;
    private static final byte NONE = 0;
    private static final byte TREE = 1;
    private static final byte SURR = 2;

    public static int removeOrphanedBranchNodes(World world, @Nullable ChunkPos chunkPos, int radius) {
        if (chunkPos == null) {
            throw new NullPointerException("Null chunk position");
        }
        HashSet<BlockPos> found = new HashSet<BlockPos>();
        BlockBounds bounds = ChunkTreeHelper.getEffectiveBlockBounds(world, chunkPos, radius);
        int orphansCleared = 0;
        for (BlockPos pos : bounds) {
            Direction trunkDir;
            BlockPos trunkPos;
            BlockState trunkState;
            Optional<BranchBlock> trunk;
            BlockState state = world.func_180495_p(pos);
            Optional<BranchBlock> branchBlock = TreeHelper.getBranchOpt(state);
            if (!branchBlock.isPresent()) continue;
            BlockPos rootPos = TreeHelper.findRootNode(world, pos);
            if (rootPos == BlockPos.field_177992_a) {
                ChunkTreeHelper.doTreeDestroy(world, branchBlock.get(), pos);
                ++orphansCleared;
                continue;
            }
            BlockState rootyState = world.func_180495_p(rootPos);
            Optional<RootyBlock> rootyBlock = TreeHelper.getRootyOpt(rootyState);
            if (!rootyBlock.isPresent() || !(trunk = TreeHelper.getBranchOpt(trunkState = world.func_180495_p(trunkPos = rootPos.func_177972_a(trunkDir = rootyBlock.get().getTrunkDirection((IBlockReader)world, rootPos))))).isPresent()) continue;
            MapSignal signal = new MapSignal();
            signal.destroyLoopedNodes = false;
            trunk.get().analyse(trunkState, (IWorld)world, trunkPos, null, signal);
            if (signal.multiroot || signal.overflow) {
                ChunkTreeHelper.doTreeDestroy(world, branchBlock.get(), pos);
                ++orphansCleared;
                continue;
            }
            trunk.get().analyse(trunkState, (IWorld)world, trunkPos, null, new MapSignal(new CollectorNode(found)));
        }
        return orphansCleared;
    }

    public static int removeAllBranchesFromChunk(World world, @Nullable ChunkPos chunkPos, int radius) {
        if (chunkPos == null) {
            throw new NullPointerException("Null chunk position");
        }
        BlockBounds bounds = ChunkTreeHelper.getEffectiveBlockBounds(world, chunkPos, radius);
        int treesCleared = 0;
        for (BlockPos pos : bounds) {
            BlockState state = world.func_180495_p(pos);
            Optional<BranchBlock> branchBlock = TreeHelper.getBranchOpt(state);
            if (!branchBlock.isPresent()) continue;
            ChunkTreeHelper.doTreeDestroy(world, branchBlock.get(), pos);
            ++treesCleared;
        }
        return treesCleared;
    }

    public static BlockBounds getEffectiveBlockBounds(World world, ChunkPos cPos, int radius) {
        Chunk chunk = world.func_212866_a_(cPos.field_77276_a, cPos.field_77275_b);
        BlockBounds bounds = new BlockBounds(world, cPos);
        bounds.shrink(Direction.UP, world.func_234938_ad_() - 1 - (ChunkTreeHelper.getTopFilledSegment(chunk) + 16));
        for (Direction dir : Direction.Plane.HORIZONTAL.func_239636_a_().collect(Collectors.toList())) {
            bounds.expand(dir, radius * 16);
        }
        return bounds;
    }

    private static int getTopFilledSegment(Chunk chunk) {
        ChunkSection lastChunkSection = ChunkTreeHelper.getLastSection(chunk);
        return lastChunkSection == null ? 0 : lastChunkSection.func_222632_g();
    }

    @Nullable
    private static ChunkSection getLastSection(Chunk chunk) {
        ChunkSection[] sections = chunk.func_76587_i();
        for (int i = sections.length - 1; i >= 0; --i) {
            if (sections[i] == null || sections[i].func_76663_a()) continue;
            return sections[i];
        }
        return null;
    }

    private static void doTreeDestroy(World world, BranchBlock branchBlock, BlockPos pos) {
        BranchDestructionData destroyData = branchBlock.destroyBranchFromNode(world, pos, Direction.DOWN, true, null);
        destroyData.leavesDrops.clear();
        FallingTreeEntity.dropTree(world, destroyData, new ArrayList<ItemStack>(0), FallingTreeEntity.DestroyType.ROOT);
        ChunkTreeHelper.cleanupNeighbors(world, destroyData);
    }

    public static void cleanupNeighbors(World world, BranchDestructionData destroyData) {
        if (world.field_72995_K) {
            return;
        }
        BlockBounds treeBounds = new BlockBounds(destroyData.cutPos);
        destroyData.getPositions(BranchDestructionData.PosType.LEAVES, true).forEach(treeBounds::union);
        destroyData.getPositions(BranchDestructionData.PosType.BRANCHES, true).forEach(treeBounds::union);
        treeBounds.expand(1);
        SimpleVoxmap treeVoxmap = new SimpleVoxmap(treeBounds);
        destroyData.getPositions(BranchDestructionData.PosType.LEAVES, true).forEach(pos -> treeVoxmap.setVoxel((BlockPos)pos, (byte)1));
        destroyData.getPositions(BranchDestructionData.PosType.BRANCHES, true).forEach(pos -> treeVoxmap.setVoxel((BlockPos)pos, (byte)1));
        SimpleVoxmap outlineVoxmap = new SimpleVoxmap(treeVoxmap);
        treeVoxmap.getAllNonZero((byte)1).forEach(pos -> {
            for (Direction dir : Direction.values()) {
                outlineVoxmap.setVoxel((BlockPos)pos.func_243531_h(dir.func_176730_m()), (byte)2);
            }
        });
        treeVoxmap.getAllNonZero((byte)1).forEach(pos -> outlineVoxmap.setVoxel((BlockPos)pos, (byte)0));
        outlineVoxmap.getAllNonZero((byte)2).forEach(pos -> ChunkTreeHelper.cleanupBlock(world, (BlockPos)pos));
    }

    public static void cleanupBlock(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_150350_a) {
            return;
        }
        Block block = state.func_177230_c();
        if (block instanceof SnowBlock || block instanceof FruitBlock || block instanceof PodBlock || block instanceof SurfaceRootBlock) {
            world.func_180501_a(pos, BlockStates.AIR, 2);
        } else if (block instanceof VineBlock) {
            ChunkTreeHelper.cleanupVines(world, pos);
        }
    }

    public static void cleanupVines(World world, BlockPos pos) {
        BlockPos.Mutable mblock = pos.func_239590_i_();
        while (world.func_180495_p((BlockPos)mblock).func_177230_c() instanceof VineBlock) {
            world.func_180501_a((BlockPos)mblock, BlockStates.AIR, 2);
            mblock.func_189536_c(Direction.DOWN);
        }
    }
}

