/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NetVolumeNode;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.ferreusveritas.dynamictrees.util.BranchConnectionData;
import com.ferreusveritas.dynamictrees.util.Connections;
import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;

public class BranchDestructionData {
    public final Species species;
    public final int[] destroyedBranchesRadiusPosition;
    public final int[] destroyedBranchesConnections;
    public final int[] destroyedBranchesBlockIndex;
    public final int[] destroyedLeaves;
    public final int[] destroyedLeavesBlockIndex;
    public final List<BranchBlock.ItemStackPos> leavesDrops;
    public final int[] endPoints;
    public final NetVolumeNode.Volume woodVolume;
    public final Direction cutDir;
    public final Direction toolDir;
    public final BlockPos cutPos;
    public final int trunkHeight;
    public static final BlockBounds bounds = new BlockBounds(new BlockPos(-64, -64, -64), new BlockPos(64, 64, 64));

    public BranchDestructionData() {
        this.species = Species.NULL_SPECIES;
        this.destroyedBranchesConnections = new int[0];
        this.destroyedBranchesRadiusPosition = new int[0];
        this.destroyedBranchesBlockIndex = new int[0];
        this.destroyedLeaves = new int[0];
        this.destroyedLeavesBlockIndex = new int[0];
        this.leavesDrops = new ArrayList<BranchBlock.ItemStackPos>(0);
        this.endPoints = new int[0];
        this.woodVolume = new NetVolumeNode.Volume();
        this.cutDir = Direction.DOWN;
        this.toolDir = Direction.DOWN;
        this.cutPos = BlockPos.field_177992_a;
        this.trunkHeight = 0;
    }

    public BranchDestructionData(Species species, Map<BlockPos, BranchConnectionData> branches, Map<BlockPos, BlockState> leaves, List<BranchBlock.ItemStackPos> leavesDrops, List<BlockPos> ends, NetVolumeNode.Volume volume, BlockPos cutPos, Direction cutDir, Direction toolDir, int trunkHeight) {
        this.species = species;
        int[][] encodedBranchData = this.convertBranchesToIntArrays(branches);
        this.destroyedBranchesRadiusPosition = encodedBranchData[0];
        this.destroyedBranchesConnections = encodedBranchData[1];
        this.destroyedBranchesBlockIndex = encodedBranchData[2];
        int[][] encodedLeavesData = this.convertLeavesToIntArray(leaves, species);
        this.destroyedLeaves = encodedLeavesData[0];
        this.destroyedLeavesBlockIndex = encodedLeavesData[1];
        this.leavesDrops = leavesDrops;
        this.endPoints = this.convertEndPointsToIntArray(ends);
        this.woodVolume = volume;
        this.cutPos = cutPos;
        this.cutDir = cutDir;
        this.toolDir = toolDir;
        this.trunkHeight = trunkHeight;
    }

    public BranchDestructionData(CompoundNBT nbt) {
        this.species = TreeRegistry.findSpecies(new ResourceLocation(nbt.func_74779_i("species")));
        this.destroyedBranchesRadiusPosition = nbt.func_74759_k("branchpos");
        this.destroyedBranchesConnections = nbt.func_74759_k("branchcon");
        this.destroyedBranchesBlockIndex = nbt.func_74759_k("branchblock");
        this.destroyedLeaves = nbt.func_74759_k("leavespos");
        this.destroyedLeavesBlockIndex = nbt.func_74759_k("leavesblock");
        this.leavesDrops = new ArrayList<BranchBlock.ItemStackPos>();
        this.endPoints = nbt.func_74759_k("ends");
        this.woodVolume = new NetVolumeNode.Volume(nbt.func_74759_k("volume"));
        this.cutPos = new BlockPos(nbt.func_74762_e("cutx"), nbt.func_74762_e("cuty"), nbt.func_74762_e("cutz"));
        this.cutDir = Direction.values()[MathHelper.func_76125_a((int)nbt.func_74762_e("cutdir"), (int)0, (int)(Direction.values().length - 1))];
        this.toolDir = Direction.values()[MathHelper.func_76125_a((int)nbt.func_74762_e("tooldir"), (int)0, (int)(Direction.values().length - 1))];
        this.trunkHeight = nbt.func_74762_e("trunkheight");
    }

    public CompoundNBT writeToNBT(CompoundNBT tag) {
        tag.func_74778_a("species", this.species.getRegistryName().toString());
        tag.func_74783_a("branchpos", this.destroyedBranchesRadiusPosition);
        tag.func_74783_a("branchcon", this.destroyedBranchesConnections);
        tag.func_74783_a("branchblock", this.destroyedBranchesBlockIndex);
        tag.func_74783_a("leavespos", this.destroyedLeaves);
        tag.func_74783_a("leavesblock", this.destroyedLeavesBlockIndex);
        tag.func_74783_a("ends", this.endPoints);
        tag.func_74783_a("volume", this.woodVolume.getRawVolumesArray());
        tag.func_74768_a("cutx", this.cutPos.func_177958_n());
        tag.func_74768_a("cuty", this.cutPos.func_177956_o());
        tag.func_74768_a("cutz", this.cutPos.func_177952_p());
        tag.func_74768_a("cutdir", this.cutDir.func_176745_a());
        tag.func_74768_a("tooldir", this.toolDir.func_176745_a());
        tag.func_74768_a("trunkheight", this.trunkHeight);
        return tag;
    }

    private int[][] convertBranchesToIntArrays(Map<BlockPos, BranchConnectionData> branchList) {
        BlockState origState;
        int[] radPosData = new int[branchList.size()];
        int[] connectionData = new int[branchList.size()];
        int[] blockIndexData = new int[branchList.size()];
        int index = 0;
        BranchConnectionData origConnData = branchList.get(BlockPos.field_177992_a);
        if (origConnData != null && (origState = origConnData.getBlockState()) != null) {
            radPosData[index] = this.encodeBranchesRadiusPos(BlockPos.field_177992_a, (BranchBlock)origState.func_177230_c(), origState);
            connectionData[index] = this.encodeBranchesConnections(origConnData.getConnections());
            blockIndexData[index++] = this.encodeBranchBlocks((BranchBlock)origState.func_177230_c());
            branchList.remove(BlockPos.field_177992_a);
        }
        for (Map.Entry<BlockPos, BranchConnectionData> set : branchList.entrySet()) {
            BlockPos relPos = set.getKey();
            BranchConnectionData connData = set.getValue();
            BlockState state = connData.getBlockState();
            Block block = state.func_177230_c();
            if (!(block instanceof BranchBlock) || !bounds.inBounds(relPos)) continue;
            radPosData[index] = this.encodeBranchesRadiusPos(relPos, (BranchBlock)block, state);
            connectionData[index] = this.encodeBranchesConnections(connData.getConnections());
            blockIndexData[index++] = this.encodeBranchBlocks((BranchBlock)block);
        }
        radPosData = Arrays.copyOf(radPosData, index);
        connectionData = Arrays.copyOf(connectionData, index);
        blockIndexData = Arrays.copyOf(blockIndexData, index);
        return new int[][]{radPosData, connectionData, blockIndexData};
    }

    private int encodeBranchesRadiusPos(BlockPos relPos, BranchBlock branchBlock, BlockState state) {
        return (branchBlock.getRadius(state) & 0x1F) << 24 | BranchDestructionData.encodeRelBlockPos(relPos);
    }

    private int encodeBranchesConnections(Connections exState) {
        int result = 0;
        int[] radii = exState.getAllRadii();
        for (Direction face : Direction.values()) {
            int faceIndex = face.func_176745_a();
            int rad = radii[faceIndex];
            result |= (rad & 0x1F) << faceIndex * 5;
        }
        return result;
    }

    private int encodeBranchBlocks(BranchBlock branch) {
        return branch.getFamily().getBranchBlockIndex(branch);
    }

    public int getNumBranches() {
        return this.destroyedBranchesRadiusPosition.length;
    }

    public BlockPos getBranchRelPos(int index) {
        return BranchDestructionData.decodeRelPos(this.destroyedBranchesRadiusPosition[index]);
    }

    public int getBranchRadius(int index) {
        return this.decodeBranchRadius(this.destroyedBranchesRadiusPosition[index]);
    }

    private int decodeBranchRadius(int encoded) {
        return encoded >> 24 & 0x1F;
    }

    @Nullable
    public BlockState getBranchBlockState(int index) {
        BranchBlock branch;
        if (this.destroyedBranchesBlockIndex.length > 0 && (branch = this.species.getFamily().getValidBranchBlock(this.destroyedBranchesBlockIndex[index])) != null) {
            int radius = this.decodeBranchRadius(this.destroyedBranchesRadiusPosition[index]);
            return branch.getStateForRadius(radius);
        }
        return null;
    }

    public void getConnections(int index, int[] connections) {
        int encodedConnections = this.destroyedBranchesConnections[index];
        for (Direction face : Direction.values()) {
            int rad = encodedConnections >> face.func_176745_a() * 5 & 0x1F;
            connections[face.func_176745_a()] = Math.max(0, rad);
        }
    }

    private int[][] convertLeavesToIntArray(Map<BlockPos, BlockState> leavesList, Species species) {
        int[] posData = new int[leavesList.size()];
        int[] blockIndexData = new int[leavesList.size()];
        int index = 0;
        for (Map.Entry<BlockPos, BlockState> set : leavesList.entrySet()) {
            BlockPos relPos = set.getKey();
            BlockState state = set.getValue();
            Block block = state.func_177230_c();
            if (!(block instanceof DynamicLeavesBlock) || !bounds.inBounds(relPos)) continue;
            posData[index] = this.encodeLeavesPos(relPos, (DynamicLeavesBlock)block, state);
            blockIndexData[index++] = this.encodeLeavesBlocks((DynamicLeavesBlock)block, species);
        }
        posData = Arrays.copyOf(posData, index);
        blockIndexData = Arrays.copyOf(blockIndexData, index);
        return new int[][]{posData, blockIndexData};
    }

    private int encodeLeavesPos(BlockPos relPos, DynamicLeavesBlock block, BlockState state) {
        return (Integer)state.func_177229_b((Property)DynamicLeavesBlock.field_208494_a) << 24 | BranchDestructionData.encodeRelBlockPos(relPos);
    }

    private int encodeLeavesBlocks(DynamicLeavesBlock block, Species species) {
        return species.getLeafBlockIndex(block);
    }

    public int getNumLeaves() {
        return this.destroyedLeaves.length;
    }

    public BlockPos getLeavesRelPos(int index) {
        return this.decodeLeavesRelPos(this.destroyedLeaves[index]);
    }

    private BlockPos decodeLeavesRelPos(int encoded) {
        return BranchDestructionData.decodeRelPos(encoded);
    }

    public int getLeavesHydro(int index) {
        return this.decodeLeavesHydro(this.destroyedLeaves[index]);
    }

    private int decodeLeavesHydro(int encoded) {
        return encoded >> 24 & 0xF;
    }

    public LeavesProperties getLeavesProperties(int index) {
        return this.species.getValidLeavesProperties(this.destroyedLeavesBlockIndex[index]);
    }

    public BlockState getLeavesBlockState(int index) {
        DynamicLeavesBlock leaves = this.species.getValidLeafBlock(this.destroyedLeavesBlockIndex[index]);
        if (leaves != null) {
            return leaves.func_176223_P();
        }
        return null;
    }

    private int[] convertEndPointsToIntArray(List<BlockPos> endPoints) {
        int[] data = new int[endPoints.size()];
        int index = 0;
        for (BlockPos relPos : endPoints) {
            if (!bounds.inBounds(relPos)) continue;
            data[index++] = BranchDestructionData.encodeRelBlockPos(relPos);
        }
        return Arrays.copyOf(data, index);
    }

    public int getNumEndpoints() {
        return this.endPoints.length;
    }

    public BlockPos getEndPointRelPos(int index) {
        return BranchDestructionData.decodeRelPos(this.endPoints[index]);
    }

    public Iterable<BlockPos> getPositions(PosType posType) {
        return this.getPositions(posType, true);
    }

    public Iterable<BlockPos> getPositions(PosType posType, boolean absolute) {
        int limit;
        Function<Integer, BlockPos> getter;
        switch (posType) {
            default: {
                getter = absolute ? i -> this.getBranchRelPos((int)i).func_177971_a((Vector3i)this.cutPos) : this::getBranchRelPos;
                limit = this.getNumBranches();
                break;
            }
            case ENDPOINTS: {
                getter = absolute ? i -> this.getEndPointRelPos((int)i).func_177971_a((Vector3i)this.cutPos) : this::getEndPointRelPos;
                limit = this.getNumEndpoints();
                break;
            }
            case LEAVES: {
                getter = absolute ? i -> this.getLeavesRelPos((int)i).func_177971_a((Vector3i)this.cutPos) : this::getLeavesRelPos;
                limit = this.getNumLeaves();
            }
        }
        return new Iterable<BlockPos>(){

            @Override
            @Nonnull
            public Iterator<BlockPos> iterator() {
                return new AbstractIterator<BlockPos>(){
                    private int index = 0;

                    protected BlockPos computeNext() {
                        return this.index < limit ? (BlockPos)getter.apply(this.index++) : (BlockPos)this.endOfData();
                    }
                };
            }
        };
    }

    public static int encodeRelBlockPos(BlockPos relPos) {
        return (relPos.func_177958_n() + 64 & 0xFF) << 16 | (relPos.func_177956_o() + 64 & 0xFF) << 8 | relPos.func_177952_p() + 64 & 0xFF;
    }

    public static BlockPos decodeRelPos(int encoded) {
        return new BlockPos((encoded >> 16 & 0xFF) - 64, (encoded >> 8 & 0xFF) - 64, (encoded & 0xFF) - 64);
    }

    public static enum PosType {
        BRANCHES,
        LEAVES,
        ENDPOINTS;

    }

    public static class BlockStateWithConnections {
        private final BlockState blockState;
        private final int[] connections;

        public BlockStateWithConnections(BlockState blockState) {
            this.blockState = blockState;
            this.connections = new int[6];
        }

        public BlockState getBlockState() {
            return this.blockState;
        }

        public int[] getConnections() {
            return this.connections;
        }
    }
}

