/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.trees.species;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.leaves.PalmLeavesProperties;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKits;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.nodemappers.FindEndsNode;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.mojang.datafixers.util.Function3;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class PalmSpecies
extends Species {
    public static final TypedRegistry.EntryType<Species> TYPE = PalmSpecies.createDefaultType((Function3<ResourceLocation, Family, LeavesProperties, Species>)((Function3)PalmSpecies::new));

    public PalmSpecies(ResourceLocation name, Family family, LeavesProperties leavesProperties) {
        super(name, family, leavesProperties);
        this.setGrowthLogicKit(GrowthLogicKits.PALM);
    }

    @Override
    public boolean postGrow(World world, BlockPos rootPos, BlockPos treePos, int fertility, boolean natural) {
        BlockState trunkBlockState = world.func_180495_p(treePos);
        BranchBlock branch = TreeHelper.getBranch(trunkBlockState);
        if (branch == null) {
            return false;
        }
        FindEndsNode endFinder = new FindEndsNode();
        MapSignal signal = new MapSignal(endFinder);
        branch.analyse(trunkBlockState, (IWorld)world, treePos, Direction.DOWN, signal);
        List<BlockPos> endPoints = endFinder.getEnds();
        for (BlockPos endPoint : endPoints) {
            TreeHelper.ageVolume((IWorld)world, endPoint, 2, 3, 3, SafeChunkBounds.ANY);
        }
        int radius = branch.getRadius(world.func_180495_p(treePos.func_177984_a()));
        if (radius != 0) {
            branch.setRadius((IWorld)world, treePos, radius + 1, null);
        }
        return super.postGrow(world, rootPos, treePos, fertility, natural);
    }

    @Override
    protected boolean transitionToTree(World world, BlockPos pos, Family family) {
        family.getBranch().ifPresent(branch -> branch.setRadius((IWorld)world, pos, family.getPrimaryThickness(), null));
        world.func_175656_a(pos.func_177984_a(), (BlockState)this.getLeavesProperties().getDynamicLeavesState().func_206870_a((Property)DynamicLeavesBlock.field_208494_a, (Comparable)Integer.valueOf(4)));
        world.func_175656_a(pos.func_177981_b(2), (BlockState)this.getLeavesProperties().getDynamicLeavesState().func_206870_a((Property)DynamicLeavesBlock.field_208494_a, (Comparable)Integer.valueOf(3)));
        this.placeRootyDirtBlock((IWorld)world, pos.func_177977_b(), 15);
        return true;
    }

    @Override
    public void postGeneration(PostGenerationContext context) {
        IWorld world = context.world();
        if (!context.endPoints().isEmpty()) {
            BlockPos tip = context.endPoints().get(0).func_177981_b(2);
            if (context.bounds().inBounds(tip, true) && world.func_180495_p(tip).func_177230_c() instanceof DynamicLeavesBlock) {
                for (CoordUtils.Surround surr : CoordUtils.Surround.values()) {
                    BlockPos leafPos = tip.func_177971_a(surr.getOffset());
                    BlockState leafState = world.func_180495_p(leafPos);
                    if (!(leafState.func_177230_c() instanceof DynamicLeavesBlock)) continue;
                    DynamicLeavesBlock block = (DynamicLeavesBlock)leafState.func_177230_c();
                    world.func_180501_a(leafPos, block.getLeavesBlockStateForPlacement(world, leafPos, leafState, (Integer)leafState.func_177229_b((Property)LeavesBlock.field_208494_a), true), 2);
                }
            }
        }
        super.postGeneration(context);
    }

    @Override
    @Nullable
    public HashMap<BlockPos, BlockState> getFellingLeavesClusters(BranchDestructionData destructionData) {
        int endPointsNum = destructionData.getNumEndpoints();
        if (endPointsNum < 1) {
            return null;
        }
        HashMap<BlockPos, BlockState> leaves = new HashMap<BlockPos, BlockState>();
        for (int i = 0; i < endPointsNum; ++i) {
            BlockPos relPos = destructionData.getEndPointRelPos(i).func_177981_b(2);
            relPos = relPos.func_177977_b();
            LeavesProperties leavesProperties = destructionData.species.getLeavesProperties();
            HashSet<BlockPos> existingLeaves = new HashSet<BlockPos>();
            for (int j = 0; j < destructionData.getNumLeaves(); ++j) {
                existingLeaves.add(destructionData.getLeavesRelPos(j));
            }
            if (existingLeaves.contains(relPos)) {
                leaves.put(relPos, leavesProperties.getDynamicLeavesState(4));
            }
            if (existingLeaves.contains(relPos.func_177984_a())) {
                leaves.put(relPos.func_177984_a(), leavesProperties.getDynamicLeavesState(3));
            }
            for (int hydro = 1; hydro <= 2; ++hydro) {
                BlockState state = leavesProperties.getDynamicLeavesState(hydro);
                for (CoordUtils.Surround surr : PalmLeavesProperties.DynamicPalmLeavesBlock.hydroSurroundMap[hydro]) {
                    BlockPos leafPos = relPos.func_177984_a().func_177971_a(surr.getOpposite().getOffset());
                    if (!existingLeaves.contains(leafPos)) continue;
                    leaves.put(leafPos, PalmLeavesProperties.DynamicPalmLeavesBlock.getDirectionState(state, surr));
                }
            }
        }
        return leaves;
    }
}

