/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.substances;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.substances.SubstanceEffect;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.RootyBlock;
import com.ferreusveritas.dynamictrees.systems.nodemappers.FreezerNode;
import com.ferreusveritas.dynamictrees.trees.Species;
import net.minecraft.block.BlockState;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class FreezeSubstance
implements SubstanceEffect {
    @Override
    public boolean apply(World world, BlockPos rootPos) {
        BlockState rootyState = world.func_180495_p(rootPos);
        RootyBlock dirt = TreeHelper.getRooty(rootyState);
        Species species = dirt.getSpecies(rootyState, (IWorld)world, rootPos);
        if (species != Species.NULL_SPECIES && dirt != null) {
            if (world.field_72995_K) {
                TreeHelper.treeParticles(world, rootPos, ParticleTypes.field_197629_v, 8);
            } else {
                dirt.startAnalysis((IWorld)world, rootPos, new MapSignal(new FreezerNode(species)));
                dirt.fertilize(world, rootPos, -15);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "freeze";
    }

    @Override
    public boolean isLingering() {
        return false;
    }
}

