/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.nodemappers;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.systems.BranchConnectables;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.BlockStates;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class DestroyerNode
implements NodeInspector {
    Species species;
    private final List<BlockPos> endPoints = new ArrayList<BlockPos>(32);
    private PlayerEntity player = null;

    public DestroyerNode(Species species) {
        this.species = species;
    }

    public DestroyerNode setPlayer(PlayerEntity player) {
        this.player = player;
        return this;
    }

    public List<BlockPos> getEnds() {
        return this.endPoints;
    }

    @Override
    public boolean run(BlockState blockState, IWorld world, BlockPos pos, @Nullable Direction fromDir) {
        if (BranchConnectables.getConnectionRadiusForBlock(blockState, (IBlockReader)world, pos, fromDir == null ? null : fromDir.func_176734_d()) > 0) {
            if (this.player != null && world instanceof World) {
                TileEntity te = world.func_175625_s(pos);
                blockState.func_177230_c().removedByPlayer(blockState, (World)world, pos, this.player, true, world.func_204610_c(pos));
                blockState.func_177230_c().func_180657_a((World)world, this.player, pos, blockState, te, this.player.func_184614_ca());
            } else {
                world.func_180501_a(pos, BlockStates.AIR, 0);
            }
            return true;
        }
        BranchBlock branch = TreeHelper.getBranch(blockState);
        if (branch != null && this.species.getFamily() == branch.getFamily()) {
            boolean waterlogged;
            boolean bl = waterlogged = blockState.func_235901_b_((Property)BlockStateProperties.field_208198_y) && (Boolean)blockState.func_177229_b((Property)BlockStateProperties.field_208198_y) != false;
            if (branch.getRadius(blockState) == this.species.getFamily().getPrimaryThickness()) {
                this.endPoints.add(pos);
            }
            world.func_180501_a(pos, waterlogged ? Blocks.field_150355_j.func_176223_P() : Blocks.field_150350_a.func_176223_P(), 3);
        }
        return true;
    }

    @Override
    public boolean returnRun(BlockState blockState, IWorld world, BlockPos pos, Direction fromDir) {
        return false;
    }
}

