/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.nodemappers;

import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.systems.BranchConnectables;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class CoderNode
implements NodeInspector {
    private final ArrayList<Link> links = new ArrayList();

    @Override
    public boolean run(BlockState blockState, IWorld world, BlockPos pos, Direction fromDir) {
        if (BranchConnectables.isBlockConnectable(world.func_180495_p(pos).func_177230_c())) {
            return false;
        }
        Link link = new Link(pos);
        for (int i = this.links.size() - 1; i >= 0; --i) {
            Link l = this.links.get(i);
            if (pos.func_177958_n() + fromDir.func_82601_c() != l.pos.func_177958_n() || pos.func_177956_o() + fromDir.func_96559_d() != l.pos.func_177956_o() || pos.func_177952_p() + fromDir.func_82599_e() != l.pos.func_177952_p()) continue;
            l.links[fromDir.func_176734_d().ordinal()] = link;
            link.links[fromDir.ordinal()] = l;
            l.forks = l.forks + (i != this.links.size() - 1 ? 1 : 0);
            break;
        }
        this.links.add(link);
        return false;
    }

    @Override
    public boolean returnRun(BlockState blockState, IWorld world, BlockPos pos, Direction fromDir) {
        return false;
    }

    public byte[] compile(JoCode joCode) {
        JoCode.CodeCompiler cc = new JoCode.CodeCompiler();
        if (this.links.size() > 0) {
            this.nextLink(cc, this.links.get(0), null);
        }
        return cc.compile();
    }

    private void nextLink(JoCode.CodeCompiler cc, Link link, Link fromLink) {
        for (int dir = 0; dir < 6; ++dir) {
            Link l = link.links[dir];
            if (l == null || l == fromLink) continue;
            if (link.forks > 0) {
                cc.addFork();
            }
            cc.addDirection((byte)dir);
            this.nextLink(cc, l, link);
            if (link.forks <= 0) continue;
            cc.addReturn();
            --link.forks;
        }
    }

    private class Link {
        BlockPos pos;
        int forks;
        Link[] links;

        public Link(BlockPos pos) {
            this.pos = pos;
            this.links = new Link[6];
        }
    }
}

