/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeatures;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.compat.seasons.SeasonHelper;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.systems.nodemappers.FindEndsNode;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.WorldContext;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractTopPlantBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.VineBlock;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;

public class VinesGenFeature
extends GenFeature {
    protected final BooleanProperty[] sideVineStates = new BooleanProperty[]{null, null, VineBlock.field_176273_b, VineBlock.field_176279_N, VineBlock.field_176280_O, VineBlock.field_176278_M};
    public static final ConfigurationProperty<Integer> MAX_LENGTH = ConfigurationProperty.integer("max_length");
    public static final ConfigurationProperty<Block> BLOCK = ConfigurationProperty.block("block");
    public static final ConfigurationProperty<Block> TIP_BLOCK = ConfigurationProperty.block("tip_block");
    public static final ConfigurationProperty<VineType> VINE_TYPE = ConfigurationProperty.property("vine_type", VineType.class);

    public VinesGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(QUANTITY, MAX_LENGTH, VERTICAL_SPREAD, RAY_DISTANCE, BLOCK, TIP_BLOCK, VINE_TYPE, FRUITING_RADIUS);
    }

    @Override
    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(QUANTITY, 4)).with(MAX_LENGTH, 8)).with(VERTICAL_SPREAD, Float.valueOf(60.0f))).with(RAY_DISTANCE, Float.valueOf(5.0f))).with(BLOCK, Blocks.field_150395_bd)).with(TIP_BLOCK, null)).with(VINE_TYPE, VineType.SIDE)).with(FRUITING_RADIUS, -1);
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        if (!context.isWorldGen() || context.endPoints().isEmpty()) {
            return false;
        }
        VineType vineType = configuration.get(VINE_TYPE);
        int quantity = (Integer)configuration.get(QUANTITY);
        block4: for (int i = 0; i < quantity; ++i) {
            BlockPos endPoint = context.endPoints().get(context.random().nextInt(context.endPoints().size()));
            switch (vineType) {
                case SIDE: {
                    this.addSideVines(configuration, context.world(), context.species(), context.pos(), endPoint, context.bounds(), true);
                    continue block4;
                }
                case CEILING: 
                case FLOOR: {
                    this.addVerticalVines(configuration, context.world(), context.species(), context.pos(), endPoint, context.bounds(), true);
                }
            }
        }
        return true;
    }

    @Override
    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        IWorld world = context.world();
        BlockPos rootPos = context.pos();
        Species species = context.species();
        int fruitingRadius = (Integer)configuration.get(FRUITING_RADIUS);
        if (fruitingRadius < 0 || context.fertility() < 1) {
            return false;
        }
        BlockState blockState = world.func_180495_p(context.treePos());
        BranchBlock branch = TreeHelper.getBranch(blockState);
        if (branch != null && branch.getRadius(blockState) >= fruitingRadius && context.natural() && SeasonHelper.globalSeasonalFruitProductionFactor(WorldContext.create(world), rootPos, false) > world.func_201674_k().nextFloat()) {
            FindEndsNode endFinder = new FindEndsNode();
            TreeHelper.startAnalysisFromRoot(world, rootPos, new MapSignal(endFinder));
            List<BlockPos> endPoints = endFinder.getEnds();
            int qty = (Integer)configuration.get(QUANTITY);
            if (!endPoints.isEmpty()) {
                for (int i = 0; i < qty; ++i) {
                    BlockPos endPoint = endPoints.get(world.func_201674_k().nextInt(endPoints.size()));
                    if (configuration.get(VINE_TYPE) == VineType.SIDE) {
                        this.addSideVines(configuration, world, species, rootPos, endPoint, SafeChunkBounds.ANY, false);
                        continue;
                    }
                    this.addVerticalVines(configuration, world, species, rootPos, endPoint, SafeChunkBounds.ANY, false);
                }
                return true;
            }
        }
        return true;
    }

    protected void addSideVines(GenFeatureConfiguration configuration, IWorld world, Species species, BlockPos rootPos, BlockPos branchPos, SafeChunkBounds safeBounds, boolean worldgen) {
        BlockRayTraceResult result = CoordUtils.branchRayTrace(world, species, rootPos, branchPos, 90.0f, ((Float)configuration.get(VERTICAL_SPREAD)).floatValue(), ((Float)configuration.get(RAY_DISTANCE)).floatValue(), safeBounds);
        if (result == null) {
            return;
        }
        BlockPos vinePos = result.func_216350_a().func_177972_a(result.func_216354_b());
        if (vinePos == BlockPos.field_177992_a || !safeBounds.inBounds(vinePos, true)) {
            return;
        }
        BooleanProperty vineSide = this.sideVineStates[result.func_216354_b().func_176734_d().ordinal()];
        if (vineSide == null) {
            return;
        }
        BlockState vineState = (BlockState)configuration.get(BLOCK).func_176223_P().func_206870_a((Property)vineSide, (Comparable)Boolean.valueOf(true));
        this.placeVines(world, vinePos, vineState, configuration.get(MAX_LENGTH), null, configuration.get(VINE_TYPE), worldgen);
    }

    protected void addVerticalVines(GenFeatureConfiguration configuration, IWorld world, Species species, BlockPos rootPos, BlockPos branchPos, SafeChunkBounds safeBounds, boolean worldgen) {
        BlockPos vinePos = CoordUtils.getRayTraceFruitPos(world, species, rootPos, branchPos, safeBounds);
        if (!safeBounds.inBounds(vinePos, true)) {
            return;
        }
        if (configuration.get(VINE_TYPE) == VineType.FLOOR) {
            vinePos = this.findGround(world, vinePos);
        }
        if (vinePos == BlockPos.field_177992_a) {
            return;
        }
        this.placeVines(world, vinePos, configuration.get(BLOCK).func_176223_P(), configuration.get(MAX_LENGTH), configuration.getAsOptional(TIP_BLOCK).map(block -> (BlockState)block.func_176223_P().func_206870_a((Property)AbstractTopPlantBlock.field_235502_d_, (Comparable)Integer.valueOf(worldgen ? 25 : 0))).orElse(null), configuration.get(VINE_TYPE), worldgen);
    }

    private BlockPos findGround(IWorld world, BlockPos vinePos) {
        BlockPos.Mutable mPos = new BlockPos.Mutable(vinePos.func_177958_n(), vinePos.func_177956_o(), vinePos.func_177952_p());
        do {
            mPos.func_189536_c(Direction.DOWN);
            if (mPos.func_177956_o() > 0) continue;
            return BlockPos.field_177992_a;
        } while (world.func_175623_d(vinePos) || world.func_180495_p(vinePos).func_177230_c() instanceof DynamicLeavesBlock);
        return mPos.func_177984_a();
    }

    protected void placeVines(IWorld world, BlockPos vinePos, BlockState vinesState, int maxLength, @Nullable BlockState tipState, VineType vineType, boolean worldgen) {
        int len = worldgen ? MathHelper.func_76125_a((int)(world.func_201674_k().nextInt(maxLength) + 3), (int)3, (int)maxLength) : 1;
        BlockPos.Mutable mPos = new BlockPos.Mutable(vinePos.func_177958_n(), vinePos.func_177956_o(), vinePos.func_177952_p());
        tipState = tipState == null ? vinesState : tipState;
        for (int i = 0; i < len; ++i) {
            if (!world.func_175623_d((BlockPos)mPos)) {
                if (i <= 0 || vineType == VineType.SIDE) break;
                mPos.func_185336_p(mPos.func_177956_o() + (vineType == VineType.FLOOR ? -1 : 1));
                world.func_180501_a((BlockPos)mPos, tipState, 3);
                break;
            }
            world.func_180501_a((BlockPos)mPos, i == len - 1 ? tipState : vinesState, 3);
            mPos.func_185336_p(mPos.func_177956_o() + (vineType == VineType.FLOOR ? 1 : -1));
        }
    }

    public static enum VineType {
        CEILING,
        FLOOR,
        SIDE;

    }
}

