/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeatures;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.blocks.branches.SurfaceRootBlock;
import com.ferreusveritas.dynamictrees.blocks.branches.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import com.ferreusveritas.dynamictrees.util.function.TetraFunction;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class RootsGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Integer> MIN_TRUNK_RADIUS = ConfigurationProperty.integer("min_trunk_radius");
    public static final ConfigurationProperty<Integer> LEVEL_LIMIT = ConfigurationProperty.integer("level_limit");
    public static final ConfigurationProperty<Float> SCALE_FACTOR = ConfigurationProperty.floatProperty("scale_factor");
    private TetraFunction<Integer, Integer, Integer, Float, Integer> scaler = (inRadius, trunkRadius, minTrunkRadius, scaleFactor) -> {
        float scale = MathHelper.func_76131_a((float)(trunkRadius >= minTrunkRadius ? (float)trunkRadius.intValue() / scaleFactor.floatValue() : 0.0f), (float)0.0f, (float)1.0f);
        return (int)((float)inRadius.intValue() * scale);
    };
    private final SimpleVoxmap[] rootMaps = this.createRootMaps();

    public RootsGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(MIN_TRUNK_RADIUS, LEVEL_LIMIT, SCALE_FACTOR);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(MIN_TRUNK_RADIUS, 13)).with(LEVEL_LIMIT, 2)).with(SCALE_FACTOR, Float.valueOf(24.0f));
    }

    protected SimpleVoxmap[] createRootMaps() {
        byte[][] rootData = new byte[][]{{0, 3, 0, 0, 0, 0, 0, 0, 5, 6, 7, 0, 3, 2, 0, 0, 0, 8, 0, 5, 0, 0, 6, 8, 0, 8, 7, 0, 0, 0, 0, 7, 0, 0, 0, 0, 3, 4, 6, 4, 0, 0, 0, 2, 0, 0, 3, 2, 1}, {0, 3, 0, 0, 0, 0, 0, 0, 5, 6, 7, 0, 3, 2, 0, 0, 0, 8, 0, 5, 0, 0, 6, 8, 0, 8, 7, 0, 0, 0, 0, 7, 0, 0, 0, 0, 3, 4, 6, 4, 0, 0, 0, 2, 0, 0, 3, 2, 1}, {0, 0, 2, 0, 0, 0, 0, 3, 4, 6, 0, 0, 0, 0, 1, 0, 7, 8, 0, 0, 0, 0, 0, 0, 0, 7, 6, 0, 0, 0, 0, 8, 0, 5, 4, 0, 5, 6, 7, 0, 0, 2, 2, 4, 0, 0, 0, 0, 0}, {0, 4, 0, 0, 0, 0, 0, 0, 5, 6, 0, 0, 1, 0, 0, 0, 7, 0, 0, 3, 0, 0, 0, 8, 0, 8, 7, 0, 0, 0, 0, 8, 0, 5, 4, 0, 0, 6, 7, 3, 0, 2, 0, 4, 5, 0, 0, 0, 0}, {3, 4, 5, 0, 0, 0, 0, 2, 0, 6, 0, 0, 0, 0, 0, 0, 7, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 7, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 2, 3, 5, 2, 0}, {0, 0, 4, 0, 0, 0, 0, 0, 0, 6, 7, 0, 2, 0, 0, 0, 0, 8, 0, 3, 0, 5, 7, 8, 0, 6, 5, 0, 3, 0, 0, 8, 0, 2, 1, 0, 3, 0, 7, 0, 0, 0, 0, 4, 5, 6, 0, 0, 0}};
        SimpleVoxmap[] maps = new SimpleVoxmap[rootData.length];
        for (int i = 0; i < maps.length; ++i) {
            maps[i] = new SimpleVoxmap(7, 1, 7, rootData[i]).setCenter(new BlockPos(3, 0, 3));
        }
        return maps;
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        BlockPos treePos = context.pos().func_177984_a();
        int trunkRadius = TreeHelper.getRadius((IBlockReader)context.world(), treePos);
        return trunkRadius >= configuration.get(MIN_TRUNK_RADIUS) && this.startRoots(configuration, context.world(), treePos, context.species(), trunkRadius);
    }

    @Override
    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        IWorld world = context.world();
        BlockPos treePos = context.treePos();
        int trunkRadius = TreeHelper.getRadius((IBlockReader)world, treePos);
        if (context.fertility() > 0 && trunkRadius >= configuration.get(MIN_TRUNK_RADIUS)) {
            CoordUtils.Surround surr = CoordUtils.Surround.values()[world.func_201674_k().nextInt(8)];
            BlockPos dPos = treePos.func_177971_a(surr.getOffset());
            if (world.func_180495_p(dPos).func_177230_c() instanceof SurfaceRootBlock) {
                world.func_180501_a(dPos, (BlockState)DTRegistries.TRUNK_SHELL.func_176223_P().func_206870_a(TrunkShellBlock.CORE_DIR, (Comparable)((Object)surr.getOpposite())), 3);
            }
            this.startRoots(configuration, world, treePos, context.species(), trunkRadius);
        }
        return true;
    }

    public boolean startRoots(GenFeatureConfiguration configuration, IWorld world, BlockPos treePos, Species species, int trunkRadius) {
        int hash = CoordUtils.coordHashCode(treePos, 2);
        SimpleVoxmap rootMap = this.rootMaps[hash % this.rootMaps.length];
        this.nextRoot(world, rootMap, treePos, species, trunkRadius, configuration.get(MIN_TRUNK_RADIUS), configuration.get(SCALE_FACTOR).floatValue(), BlockPos.field_177992_a, 0, -1, null, 0, configuration.get(LEVEL_LIMIT));
        return true;
    }

    protected void nextRoot(IWorld world, SimpleVoxmap rootMap, BlockPos trunkPos, Species species, int trunkRadius, int minTrunkRadius, float scaleFactor, BlockPos pos, int height, int levelCount, Direction fromDir, int radius, int levelLimit) {
        for (int depth = 0; depth < 2; ++depth) {
            BlockPos currPos = trunkPos.func_177971_a((Vector3i)pos).func_177981_b(height - depth);
            BlockState placeState = world.func_180495_p(currPos);
            BlockState belowState = world.func_180495_p(currPos.func_177977_b());
            boolean onNormalCube = belowState.func_215686_e((IBlockReader)world, currPos.func_177977_b());
            if (pos != BlockPos.field_177992_a && (!this.isReplaceableWithRoots(world, placeState, currPos) || depth != 1 && !onNormalCube)) continue;
            if (radius > 0) {
                species.getFamily().getSurfaceRoot().ifPresent(root -> root.setRadius(world, currPos, radius, 3));
            }
            if (!onNormalCube) break;
            for (Direction dir : CoordUtils.HORIZONTALS) {
                int thisLevelCount;
                if (dir == fromDir) continue;
                BlockPos dPos = pos.func_177972_a(dir);
                int nextRad = this.scaler.apply(Integer.valueOf(rootMap.getVoxel(dPos)), trunkRadius, minTrunkRadius, Float.valueOf(scaleFactor));
                if (pos != BlockPos.field_177992_a && nextRad >= radius) {
                    nextRad = radius - 1;
                }
                int n = thisLevelCount = depth == 1 ? 1 : levelCount + 1;
                if (nextRad <= 0 || thisLevelCount > levelLimit) continue;
                this.nextRoot(world, rootMap, trunkPos, species, trunkRadius, minTrunkRadius, scaleFactor, dPos, height - depth, thisLevelCount, dir.func_176734_d(), nextRad, levelLimit);
            }
            break;
        }
    }

    protected boolean isReplaceableWithRoots(IWorld world, BlockState placeState, BlockPos pos) {
        if (world.func_175623_d(pos) || placeState.func_177230_c() instanceof TrunkShellBlock) {
            return true;
        }
        Material material = placeState.func_185904_a();
        return material.func_76222_j() && material != Material.field_151587_i;
    }

    public RootsGenFeature setScaler(TetraFunction<Integer, Integer, Integer, Float, Integer> scaler) {
        this.scaler = scaler;
        return this;
    }
}

