/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeatures;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.RootyBlock;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.systems.nodemappers.FindEndsNode;
import com.ferreusveritas.dynamictrees.util.BlockStates;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.MushroomBlock;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;

public class PodzolGenFeature
extends GenFeature {
    public PodzolGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
    }

    @Override
    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        if (!((Boolean)DTConfigs.PODZOL_GEN.get()).booleanValue()) {
            return false;
        }
        IWorld world = context.world();
        FindEndsNode endFinder = new FindEndsNode();
        TreeHelper.startAnalysisFromRoot(world, context.pos(), new MapSignal(endFinder));
        List<BlockPos> endPoints = endFinder.getEnds();
        if (endPoints.isEmpty()) {
            return false;
        }
        Random random = context.random();
        BlockPos pos = endPoints.get(random.nextInt(endPoints.size()));
        int x = pos.func_177958_n() + random.nextInt(5) - 2;
        int z = pos.func_177952_p() + random.nextInt(5) - 2;
        int darkThreshold = 4;
        for (int i = 0; i < 32; ++i) {
            Block block;
            BlockPos offPos = new BlockPos(x, pos.func_177956_o() - 1 - i, z);
            if (world.func_175623_d(offPos) || (block = world.func_180495_p(offPos).func_177230_c()) instanceof BranchBlock || block instanceof MushroomBlock || block instanceof LeavesBlock) continue;
            if (block instanceof FlowerBlock || block instanceof TallGrassBlock || block instanceof DoublePlantBlock) {
                if (world.func_226658_a_(LightType.SKY, offPos) > 4) continue;
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                continue;
            }
            if (block != Blocks.field_150346_d && block != Blocks.field_150349_c) break;
            if (world.func_226658_a_(LightType.SKY, offPos.func_177984_a()) <= 4) {
                world.func_180501_a(offPos, BlockStates.PODZOL, 3);
                break;
            }
            PodzolGenFeature.spreadPodzol(world, pos);
            break;
        }
        return true;
    }

    public static void spreadPodzol(IWorld world, BlockPos pos) {
        int podzolish = 0;
        for (Direction dir : CoordUtils.HORIZONTALS) {
            BlockPos deltaPos = pos.func_177972_a(dir);
            Block testBlock = world.func_180495_p(deltaPos).func_177230_c();
            podzolish += testBlock == Blocks.field_196661_l ? 1 : 0;
            if ((podzolish += testBlock instanceof RootyBlock ? 1 : 0) < 3) continue;
            world.func_180501_a(pos, BlockStates.PODZOL, 3);
            break;
        }
    }
}

