/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeatures;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.compat.seasons.SeasonHelper;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.systems.nodemappers.PodGenerationNode;
import com.ferreusveritas.dynamictrees.systems.pod.Pod;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.WorldContext;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class PodGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Pod> POD = ConfigurationProperty.property("pod", Pod.class);

    public PodGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(POD, PLACE_CHANCE);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(POD, Pod.NULL)).with(PLACE_CHANCE, Float.valueOf(0.125f));
    }

    @Override
    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        if (context.fertility() == 0) {
            IWorld world = context.world();
            if (this.shouldGrow(configuration, context.species(), context.worldContext(), context.treePos(), context.random())) {
                this.place(configuration.get(POD)::place, world, context.pos(), SeasonHelper.getSeasonValue(world, context.pos()));
            }
        }
        return false;
    }

    private boolean shouldGrow(GenFeatureConfiguration configuration, Species species, WorldContext worldContext, BlockPos treePos, Random random) {
        return species.seasonalFruitProductionFactor(worldContext, treePos) > random.nextFloat() && random.nextFloat() <= ((Float)configuration.get(PLACE_CHANCE)).floatValue();
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        if (this.shouldGenerate(configuration, context.random())) {
            this.place(configuration.get(POD)::placeDuringWorldGen, context.world(), context.pos(), context.seasonValue());
            return true;
        }
        return false;
    }

    private boolean shouldGenerate(GenFeatureConfiguration configuration, Random random) {
        return random.nextFloat() <= ((Float)configuration.get(PLACE_CHANCE)).floatValue();
    }

    private void place(PodGenerationNode.PodPlacer podPlacer, IWorld world, BlockPos rootPos, @Nullable Float seasonValue) {
        TreeHelper.startAnalysisFromRoot(world, rootPos, new MapSignal(new PodGenerationNode(podPlacer, seasonValue)));
    }
}

