/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeatures;

import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostRotContext;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraftforge.common.IPlantable;

public class MushroomRotGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> MUSHROOM = ConfigurationProperty.block("mushroom");
    public static final ConfigurationProperty<Block> ALTERNATE_MUSHROOM = ConfigurationProperty.block("alternate_mushroom");
    public static final ConfigurationProperty<Float> ALTERNATE_MUSHROOM_CHANCE = ConfigurationProperty.floatProperty("alternate_mushroom_chance");

    public MushroomRotGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(MUSHROOM, ALTERNATE_MUSHROOM, ALTERNATE_MUSHROOM_CHANCE);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(MUSHROOM, Blocks.field_150338_P)).with(ALTERNATE_MUSHROOM, Blocks.field_150337_Q)).with(ALTERNATE_MUSHROOM_CHANCE, Float.valueOf(0.25f));
    }

    @Override
    protected boolean postRot(GenFeatureConfiguration configuration, PostRotContext context) {
        Block mushroom;
        IWorld world = context.world();
        BlockPos pos = context.pos();
        Block block = mushroom = configuration.get(ALTERNATE_MUSHROOM_CHANCE).floatValue() > context.random().nextFloat() ? configuration.get(MUSHROOM) : configuration.get(ALTERNATE_MUSHROOM);
        if (context.radius() <= 4 || !this.canSustainMushroom(world, pos, mushroom) || world.func_226658_a_(LightType.SKY, pos) >= 4) {
            return false;
        }
        world.func_180501_a(pos, mushroom.func_176223_P(), 3);
        return true;
    }

    private boolean canSustainMushroom(IWorld world, BlockPos pos, Block block) {
        return block instanceof IPlantable && world.func_180495_p(pos).canSustainPlant((IBlockReader)world, pos, Direction.UP, (IPlantable)block);
    }
}

