/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeatures;

import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeatures.HugeMushroomGenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.FullGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;

public class HugeMushroomsGenFeature
extends HugeMushroomGenFeature {
    public static final ConfigurationProperty<Integer> MAX_MUSHROOMS = ConfigurationProperty.integer("max_mushrooms");
    public static final ConfigurationProperty<Integer> MAX_ATTEMPTS = ConfigurationProperty.integer("max_attempts");

    public HugeMushroomsGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        super.registerProperties();
        this.register(MAX_MUSHROOMS, MAX_ATTEMPTS);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(MAX_MUSHROOMS, 2)).with(MAX_ATTEMPTS, 4);
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        if (context.endPoints().isEmpty() || !context.isWorldGen() || context.radius() < 5) {
            return false;
        }
        IWorld world = context.world();
        BlockPos rootPos = context.pos();
        BlockPos lowest = Collections.min(context.endPoints(), Comparator.comparingInt(Vector3i::func_177956_o));
        Random rand = context.random();
        int success = 0;
        for (int tries = 0; tries < configuration.get(MAX_ATTEMPTS); ++tries) {
            int height;
            int maxHeight;
            float angle = (float)((double)rand.nextFloat() * Math.PI * 2.0);
            int xOff = (int)(MathHelper.func_76126_a((float)angle) * (float)(context.radius() - 1));
            int zOff = (int)(MathHelper.func_76134_b((float)angle) * (float)(context.radius() - 1));
            BlockPos mushPos = rootPos.func_177982_a(xOff, 0, zOff);
            mushPos = CoordUtils.findWorldSurface(world, new BlockPos((Vector3i)mushPos), context.isWorldGen()).func_177984_a();
            if (!context.bounds().inBounds(mushPos, true) || (maxHeight = lowest.func_177956_o() - mushPos.func_177956_o()) < 2 || !this.setHeight(height = MathHelper.func_76125_a((int)(rand.nextInt(maxHeight) + 3), (int)3, (int)maxHeight)).generate(configuration, new FullGenerationContext(context.world(), context.pos(), context.species(), context.biome(), context.radius(), context.bounds())) || ++success < configuration.get(MAX_MUSHROOMS)) continue;
            return true;
        }
        return false;
    }
}

