/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeatures;

import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.cells.LeafClusters;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.FullGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import com.ferreusveritas.dynamictrees.util.function.BiomePredicate;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class BushGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> LOG = ConfigurationProperty.block("log");
    public static final ConfigurationProperty<Block> LEAVES = ConfigurationProperty.block("leaves");
    public static final ConfigurationProperty<Block> SECONDARY_LEAVES = ConfigurationProperty.block("secondary_leaves");
    public static final ConfigurationProperty<Integer> SECONDARY_LEAVES_CHANCE = ConfigurationProperty.integer("secondary_leaves_chance");

    public BushGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(BIOME_PREDICATE, LOG, LEAVES, SECONDARY_LEAVES, SECONDARY_LEAVES_CHANCE);
    }

    @Override
    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(BIOME_PREDICATE, i -> true)).with(LOG, Blocks.field_196617_K)).with(LEAVES, Blocks.field_196642_W)).with(SECONDARY_LEAVES, null)).with(SECONDARY_LEAVES_CHANCE, 4);
    }

    @Override
    protected boolean generate(GenFeatureConfiguration configuration, FullGenerationContext context) {
        this.commonGen(configuration, context.world(), context.pos(), context.species(), context.random(), context.radius(), context.bounds());
        return true;
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        if (context.bounds() != SafeChunkBounds.ANY && ((BiomePredicate)configuration.get(BIOME_PREDICATE)).test(context.biome())) {
            this.commonGen(configuration, context.world(), context.pos(), context.species(), context.random(), context.radius(), context.bounds());
            return true;
        }
        return false;
    }

    protected void commonGen(GenFeatureConfiguration configuration, IWorld world, BlockPos rootPos, Species species, Random random, int radius, SafeChunkBounds safeBounds) {
        if (radius <= 2) {
            return;
        }
        boolean worldGen = safeBounds != SafeChunkBounds.ANY;
        Vector3d vTree = new Vector3d((double)rootPos.func_177958_n(), (double)rootPos.func_177956_o(), (double)rootPos.func_177952_p()).func_72441_c(0.5, 0.5, 0.5);
        for (int i = 0; i < 2; ++i) {
            int rad = MathHelper.func_76125_a((int)(random.nextInt(radius - 2) + 2), (int)2, (int)(radius - 1));
            Vector3d v = vTree.func_178787_e(new Vector3d(1.0, 0.0, 0.0).func_186678_a((double)rad).func_178785_b((float)((double)random.nextFloat() * Math.PI * 2.0)));
            BlockPos vPos = new BlockPos(v);
            if (!safeBounds.inBounds(vPos, true)) continue;
            BlockPos groundPos = CoordUtils.findWorldSurface(world, vPos, worldGen);
            BlockState soilBlockState = world.func_180495_p(groundPos);
            BlockPos pos = groundPos.func_177984_a();
            if (world.func_180495_p(groundPos).func_185904_a().func_76224_d() || !species.isAcceptableSoil((IWorldReader)world, groundPos, soilBlockState)) continue;
            world.func_180501_a(pos, configuration.get(LOG).func_176223_P(), 3);
            SimpleVoxmap leafMap = LeafClusters.BUSH;
            BlockPos.Mutable leafPos = new BlockPos.Mutable();
            for (BlockPos.Mutable dPos : leafMap.getAllNonZero()) {
                leafPos.func_181079_c(pos.func_177958_n() + dPos.func_177958_n(), pos.func_177956_o() + dPos.func_177956_o(), pos.func_177952_p() + dPos.func_177952_p());
                if (!safeBounds.inBounds((BlockPos)leafPos, true) || BushGenFeature.coordHashCode((BlockPos)leafPos) % 5 == 0 || !world.func_180495_p((BlockPos)leafPos).func_185904_a().func_76222_j()) continue;
                this.placeLeaves(configuration, world, random, (BlockPos)leafPos);
            }
        }
    }

    private void placeLeaves(GenFeatureConfiguration configuration, IWorld world, Random random, BlockPos leafPos) {
        Block leavesBlock = this.selectLeavesBlock(random, configuration.get(SECONDARY_LEAVES_CHANCE), configuration.get(LEAVES), configuration.getAsOptional(SECONDARY_LEAVES).orElse(null));
        this.placeLeavesBlock(world, leafPos, leavesBlock);
    }

    private Block selectLeavesBlock(Random random, int secondaryLeavesChance, Block leavesBlock, @Nullable Block secondaryLeavesBlock) {
        return secondaryLeavesBlock == null || random.nextInt(secondaryLeavesChance) != 0 ? leavesBlock : secondaryLeavesBlock;
    }

    private void placeLeavesBlock(IWorld world, BlockPos leafPos, Block leavesBlock) {
        BlockState leafState = leavesBlock.func_176223_P();
        if (leavesBlock instanceof LeavesBlock) {
            leafState = (BlockState)leafState.func_206870_a((Property)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true));
        }
        world.func_180501_a(leafPos, leafState, 3);
    }

    public static int coordHashCode(BlockPos pos) {
        int hash = (pos.func_177958_n() * 4111 ^ pos.func_177956_o() * 271 ^ pos.func_177952_p() * 3067) >> 1;
        return hash & 0xFFFF;
    }
}

