/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeatures;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.function.CanGrowPredicate;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class BeeNestGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> NEST_BLOCK = ConfigurationProperty.block("nest");
    public static final ConfigurationProperty<WorldGenChanceFunction> WORLD_GEN_CHANCE_FUNCTION = ConfigurationProperty.property("world_gen_chance", WorldGenChanceFunction.class);
    private static final double PLAINS_CHANCE = (double)0.05f;
    private static final double FLOWER_FOREST_CHANCE = (double)0.02f;
    private static final double FOREST_CHANCE = (double)5.0E-4f;
    private static final double CHANCE = (double)0.001f;

    public BeeNestGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(NEST_BLOCK, MAX_HEIGHT, CAN_GROW_PREDICATE, WORLD_GEN_CHANCE_FUNCTION, MAX_COUNT);
    }

    @Override
    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(NEST_BLOCK, Blocks.field_226905_ma_)).with(MAX_HEIGHT, 32)).with(CAN_GROW_PREDICATE, (world, pos) -> {
            if ((double)world.func_201674_k().nextFloat() > (double)0.001f) {
                return false;
            }
            for (BlockPos blockpos : BlockPos.Mutable.func_218278_a((BlockPos)pos.func_177977_b().func_177964_d(2).func_177985_f(2), (BlockPos)pos.func_177984_a().func_177970_e(2).func_177965_g(2))) {
                if (!world.func_180495_p(blockpos).func_235714_a_((ITag)BlockTags.field_226149_I_)) continue;
                return true;
            }
            return false;
        })).with(WORLD_GEN_CHANCE_FUNCTION, (world, pos) -> {
            RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Objects.requireNonNull(world.func_225604_a_(pos.func_177958_n() >> 2, pos.func_177956_o() >> 2, pos.func_177952_p() >> 2).getRegistryName()));
            if (BiomeDictionary.hasType((RegistryKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS)) {
                return 0.05f;
            }
            if (biomeKey == Biomes.field_185444_T) {
                return 0.02f;
            }
            if (BiomeDictionary.hasType((RegistryKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
                return 5.0E-4f;
            }
            return 0.0;
        })).with(MAX_COUNT, 1);
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        IWorld world = context.world();
        BlockPos rootPos = context.pos();
        return !((double)world.func_201674_k().nextFloat() > (Double)configuration.get(WORLD_GEN_CHANCE_FUNCTION).apply(world, rootPos)) && this.placeBeeNestInValidPlace(configuration, world, rootPos, true);
    }

    @Override
    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        if (!context.natural() || !((CanGrowPredicate)configuration.get(CAN_GROW_PREDICATE)).test(context.world(), context.pos().func_177984_a()) || context.fertility() == 0) {
            return false;
        }
        return this.placeBeeNestInValidPlace(configuration, context.world(), context.pos(), false);
    }

    private boolean placeBeeNestInValidPlace(GenFeatureConfiguration configuration, IWorld world, BlockPos rootPos, boolean worldGen) {
        int treeHeight;
        Block nestBlock = configuration.get(NEST_BLOCK);
        if (this.nestAlreadyPresent(world, nestBlock, rootPos, treeHeight = this.getTreeHeight(world, rootPos, (Integer)configuration.get(MAX_HEIGHT)))) {
            return false;
        }
        List<Pair<BlockPos, List<Direction>>> validSpaces = this.findBranchPits(configuration, world, rootPos, treeHeight);
        if (validSpaces == null) {
            return false;
        }
        if (validSpaces.size() > 0) {
            Pair<BlockPos, List<Direction>> chosenSpace = validSpaces.get(world.func_201674_k().nextInt(validSpaces.size()));
            Direction chosenDir = (Direction)((List)chosenSpace.getValue()).get(world.func_201674_k().nextInt(((List)chosenSpace.getValue()).size()));
            return this.placeBeeNestWithBees(world, nestBlock, (BlockPos)chosenSpace.getKey(), chosenDir, worldGen);
        }
        return false;
    }

    private boolean placeBeeNestWithBees(IWorld world, Block nestBlock, BlockPos pos, Direction faceDir, boolean worldGen) {
        int honeyLevel = worldGen ? world.func_201674_k().nextInt(6) : 0;
        BlockState nestState = nestBlock.func_176223_P();
        if (nestState.func_235901_b_((Property)BeehiveBlock.field_226872_b_)) {
            nestState = (BlockState)nestState.func_206870_a((Property)BeehiveBlock.field_226872_b_, (Comparable)faceDir);
        }
        if (nestState.func_235901_b_((Property)BeehiveBlock.field_226873_c_)) {
            nestState = (BlockState)nestState.func_206870_a((Property)BeehiveBlock.field_226873_c_, (Comparable)Integer.valueOf(honeyLevel));
        }
        world.func_180501_a(pos, nestState, 2);
        TileEntity blockEntity = world.func_175625_s(pos);
        if (blockEntity instanceof BeehiveTileEntity) {
            BeehiveTileEntity beehivetileentity = (BeehiveTileEntity)blockEntity;
            World thisWorld = this.worldFromIWorld(world);
            if (thisWorld == null) {
                return false;
            }
            int beeCount = worldGen ? 3 : 2 + world.func_201674_k().nextInt(2);
            for (int i = 0; i < beeCount; ++i) {
                BeeEntity beeEntity = new BeeEntity(EntityType.field_226289_e_, thisWorld);
                beehivetileentity.func_226962_a_((Entity)beeEntity, false, world.func_201674_k().nextInt(599));
            }
            return true;
        }
        return false;
    }

    @Nullable
    private World worldFromIWorld(IWorld iWorld) {
        if (iWorld instanceof WorldGenRegion) {
            return ((WorldGenRegion)iWorld).func_201672_e();
        }
        if (iWorld instanceof World) {
            return (World)iWorld;
        }
        return null;
    }

    private boolean nestAlreadyPresent(IWorld world, Block nestBlock, BlockPos rootPos, int maxHeight) {
        for (int y = 2; y < maxHeight; ++y) {
            BlockPos trunkPos = rootPos.func_177981_b(y);
            for (Direction dir : CoordUtils.HORIZONTALS) {
                if (world.func_180495_p(trunkPos.func_177972_a(dir)).func_177230_c() != nestBlock) continue;
                return true;
            }
        }
        return false;
    }

    private int getTreeHeight(IWorld world, BlockPos rootPos, int maxHeight) {
        for (int i = 1; i < maxHeight; ++i) {
            if (TreeHelper.isBranch(world.func_180495_p(rootPos.func_177981_b(i)))) continue;
            return i - 1;
        }
        return maxHeight;
    }

    @Nullable
    private List<Pair<BlockPos, List<Direction>>> findBranchPits(GenFeatureConfiguration configuration, IWorld world, BlockPos rootPos, int maxHeight) {
        int existingBlocks = 0;
        LinkedList<Pair<BlockPos, List<Direction>>> validSpaces = new LinkedList<Pair<BlockPos, List<Direction>>>();
        for (int y = 2; y < maxHeight; ++y) {
            BlockPos trunkPos = rootPos.func_177981_b(y);
            for (Direction dir : CoordUtils.HORIZONTALS) {
                BlockPos sidePos = trunkPos.func_177972_a(dir);
                if (world.func_175623_d(sidePos) && TreeHelper.isBranch(world.func_180495_p(sidePos.func_177984_a()))) {
                    LinkedList<Direction> validDirs = new LinkedList<Direction>();
                    for (Direction dir2 : CoordUtils.HORIZONTALS) {
                        if (!world.func_175623_d(sidePos.func_177972_a(dir2))) continue;
                        validDirs.add(dir2);
                    }
                    if (validDirs.size() <= 0) continue;
                    validSpaces.add((Pair<BlockPos, List<Direction>>)Pair.of((Object)sidePos, validDirs));
                    continue;
                }
                if (world.func_180495_p(sidePos).func_177230_c() != configuration.get(NEST_BLOCK) || ++existingBlocks <= (Integer)configuration.get(MAX_COUNT)) continue;
                return null;
            }
        }
        return validSpaces;
    }

    public static interface WorldGenChanceFunction
    extends BiFunction<IWorld, BlockPos, Double> {
    }
}

