/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.fruit;

import com.ferreusveritas.dynamictrees.api.resource.loading.preparation.JsonRegistryResourceLoader;
import com.ferreusveritas.dynamictrees.blocks.GrowableBlock;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.deserialisation.JsonHelper;
import com.ferreusveritas.dynamictrees.deserialisation.ResourceLocationDeserialiser;
import com.ferreusveritas.dynamictrees.systems.fruit.Fruit;
import com.ferreusveritas.dynamictrees.util.Null;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.shapes.VoxelShape;

public final class FruitResourceLoader
extends JsonRegistryResourceLoader<Fruit> {
    public FruitResourceLoader() {
        super(Fruit.REGISTRY, "fruits");
    }

    @Override
    public void registerAppliers() {
        this.loadAppliers.register("max_age", Integer.class, Fruit::setMaxAge);
        this.commonAppliers.registerListApplier("block_shapes", VoxelShape.class, (fruit, list) -> fruit.setBlockShapes(list.toArray(new VoxelShape[0]))).register("item_stack", ItemStack.class, Fruit::setItemStack);
        this.reloadAppliers.register("can_bone_meal", Boolean.class, Fruit::setCanBoneMeal).register("growth_chance", Float.class, Fruit::setGrowthChance).register("flower_hold_period_length", Float.class, Fruit::setFlowerHoldPeriodLength).register("season_offset", Float.class, Fruit::setSeasonOffset).register("min_production_factor", Float.class, Fruit::setMinProductionFactor).register("mature_action", GrowableBlock.MatureAction.class, Fruit::setMatureAction);
    }

    @Override
    protected void applyLoadAppliers(JsonRegistryResourceLoader.LoadData loadData, JsonObject json) {
        super.applyLoadAppliers(loadData, json);
        JsonObject propertiesJson = this.getBlockPropertiesJson(json);
        if (propertiesJson == null) {
            this.createBlock((Fruit)loadData.getResource(), json);
        } else {
            this.createBlock((Fruit)loadData.getResource(), json, propertiesJson);
        }
    }

    @Nullable
    private JsonObject getBlockPropertiesJson(JsonObject json) {
        return Null.applyIfNonnull(json.get("block_properties"), element -> JsonDeserialisers.JSON_OBJECT.deserialise(element).orElse(null));
    }

    private void createBlock(Fruit fruit, JsonObject json) {
        fruit.createBlock(this.getBlockRegistryName(fruit, json), fruit.getDefaultBlockProperties());
    }

    private void createBlock(Fruit fruit, JsonObject json, JsonObject propertiesJson) {
        AbstractBlock.Properties blockProperties = JsonHelper.getBlockProperties(propertiesJson, fruit.getDefaultMaterial(), fruit.getDefaultMaterialColor(), fruit::getDefaultBlockProperties, error -> this.logError(fruit.getRegistryName(), (String)error), warning -> this.logWarning(fruit.getRegistryName(), (String)warning));
        fruit.createBlock(this.getBlockRegistryName(fruit, json), blockProperties);
    }

    @Nullable
    private ResourceLocation getBlockRegistryName(Fruit fruit, JsonObject json) {
        return Null.applyIfNonnull(json.get("block_registry_name"), element -> ResourceLocationDeserialiser.create(fruit.getRegistryName().func_110624_b()).deserialise((JsonElement)element).orElse(null));
    }
}

