/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.resources.loader;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.resource.loading.preparation.JsonRegistryResourceLoader;
import com.ferreusveritas.dynamictrees.api.treepacks.JsonPropertyApplier;
import com.ferreusveritas.dynamictrees.api.treepacks.PropertyApplierResult;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.SoilHelper;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.deserialisation.JsonPropertyAppliers;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.SeedSaplingRecipe;
import com.ferreusveritas.dynamictrees.systems.fruit.Fruit;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.pod.Pod;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.BiomeList;
import com.ferreusveritas.dynamictrees.util.CommonSetup;
import com.ferreusveritas.dynamictrees.util.JsonMapWrapper;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.SoundType;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SpeciesResourceLoader
extends JsonRegistryResourceLoader<Species> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final JsonPropertyAppliers<Species> environmentFactorAppliers = new JsonPropertyAppliers<Species>(Species.class);
    private final Map<Species, Float> composterChanceCache = new HashMap<Species, Float>();

    public SpeciesResourceLoader() {
        super(Species.REGISTRY, "species");
    }

    @Override
    public void registerAppliers() {
        BiomeDictionary.Type.getAll().stream().map(type -> new JsonPropertyApplier<Species, Float>(type.toString().toLowerCase(), Species.class, Float.class, (species, factor) -> species.envFactor((BiomeDictionary.Type)type, factor.floatValue()))).forEach(this.environmentFactorAppliers::register);
        JsonDeserialisers.register(Species.CommonOverride.class, input -> JsonDeserialisers.BIOME_PREDICATE.deserialise(input).map(biomePredicate -> (world, pos) -> world instanceof IWorldReader && biomePredicate.test(((IWorldReader)world).func_226691_t_(pos))));
        this.loadAppliers.register("seed", ResourceLocation.class, this::setSeed).register("generate_seed", Boolean.class, Species::setShouldGenerateSeed).register("generate_sapling", Boolean.class, Species::setShouldGenerateSapling).register("sapling_name", String.class, Species::setSaplingName).register("seed_name", String.class, Species::setSeedName);
        this.commonAppliers.register("always_show_on_waila", Boolean.class, Species::setAlwaysShowOnWaila).register("sapling_sound", SoundType.class, Species::setSaplingSound).register("sapling_shape", VoxelShape.class, Species::setSaplingShape);
        this.gatherDataAppliers.register("sapling_shape", VoxelShape.class, Species::setSaplingShape).register("drop_seeds", Boolean.class, Species::setDropSeeds);
        this.reloadAppliers.register("tapering", Float.class, Species::setTapering).register("up_probability", Integer.class, Species::setUpProbability).register("lowest_branch_height", Integer.class, Species::setLowestBranchHeight).register("signal_energy", Float.class, Species::setSignalEnergy).register("growth_rate", Float.class, Species::setGrowthRate).register("soil_longevity", Integer.class, Species::setSoilLongevity).register("max_branch_radius", Integer.class, Species::setMaxBranchRadius).register("transformable", Boolean.class, Species::setTransformable).register("growth_logic_kit", GrowthLogicKitConfiguration.class, Species::setGrowthLogicKit).register("leaves_properties", LeavesProperties.class, Species::setLeavesProperties).register("world_gen_leaf_map_height", Integer.class, Species::setWorldGenLeafMapHeight).register("environment_factors", JsonObject.class, this::applyEnvironmentFactors).register("mega_species", ResourceLocation.class, this::setMegaSpecies).register("seed", Seed.class, Species::setSeed).register("seed_composter_chance", Float.class, this.composterChanceCache::put).register("sapling_grows_naturally", Boolean.class, Species::setCanSaplingGrowNaturally).register("primitive_sapling", SeedSaplingRecipe.class, Species::addPrimitiveSaplingRecipe).registerArrayApplier("primitive_saplings", SeedSaplingRecipe.class, Species::addPrimitiveSaplingRecipe).register("common_override", Species.CommonOverride.class, Species::setCommonOverride).register("perfect_biomes", BiomeList.class, (species, biomeList) -> species.getPerfectBiomes().addAll((Collection<Biome>)biomeList)).register("can_bone_meal_tree", Boolean.class, Species::setCanBoneMealTree).registerArrayApplier("acceptable_growth_blocks", Block.class, Species::addAcceptableBlockForGrowth).registerArrayApplier("acceptable_soils", String.class, this::addAcceptableSoil).registerListApplier("fruits", Fruit.class, Species::addFruits).registerListApplier("pods", Pod.class, Species::addPods).registerArrayApplier("features", GenFeatureConfiguration.class, Species::addGenFeature).register("does_rot", Boolean.class, Species::setDoesRot).register("drop_seeds", Boolean.class, Species::setDropSeeds);
        super.registerAppliers();
    }

    private void setSeed(Species species, ResourceLocation seedName) {
        ResourceLocation processedSeedName = TreeRegistry.processResLoc(seedName);
        species.setShouldGenerateSeed(false);
        species.setShouldGenerateSapling(false);
        CommonSetup.runOnCommonSetup(event -> {
            Item seed = (Item)ForgeRegistries.ITEMS.getValue(processedSeedName);
            if (seed instanceof Seed) {
                species.setSeed((Seed)seed);
            } else {
                LOGGER.warn("Could not find valid seed item from registry name \"" + seedName + "\".");
            }
        });
    }

    private void applyEnvironmentFactors(Species species, JsonObject jsonObject) {
        this.environmentFactorAppliers.applyAll(new JsonMapWrapper(jsonObject), species).forEachErrorWarning(error -> LOGGER.error("Error applying environment factor for species '{}': {}", (Object)species.getRegistryName(), error), warning -> LOGGER.warn("Warning applying environment factor for species '{}': {}", (Object)species.getRegistryName(), warning));
    }

    private void setMegaSpecies(Species species, ResourceLocation registryName) {
        ResourceLocation processedRegName = TreeRegistry.processResLoc(registryName);
        Species.REGISTRY.runOnNextLock(Species.REGISTRY.generateIfValidRunnable(processedRegName, species::setMegaSpecies, () -> LOGGER.warn("Could not set mega species for '" + species + "' as Species '" + processedRegName + "' was not found.")));
    }

    private PropertyApplierResult addAcceptableSoil(Species species, String acceptableSoil) {
        if (SoilHelper.getSoilFlags(acceptableSoil) == 0) {
            return PropertyApplierResult.failure("Could not find acceptable soil '" + acceptableSoil + "'.");
        }
        species.addAcceptableSoils(acceptableSoil);
        return PropertyApplierResult.success();
    }

    @Override
    protected void postLoadOnLoad(JsonRegistryResourceLoader.LoadData loadData, JsonObject json) {
        super.postLoadOnLoad(loadData, json);
        ((Species)loadData.getResource()).generateSeed().generateSapling();
    }

    @Override
    protected void postLoadOnReload(JsonRegistryResourceLoader.LoadData loadData, JsonObject json) {
        Species species = (Species)loadData.getResource();
        this.composterChanceCache.put(species, Float.valueOf(species.defaultSeedComposterChance()));
        super.postLoadOnReload(loadData, json);
        this.registerComposterChances();
    }

    private void registerComposterChances() {
        this.composterChanceCache.forEach((species, chance) -> {
            if (species.getSeed().isPresent() && chance.floatValue() > 0.0f) {
                ComposterBlock.func_220290_a((float)chance.floatValue(), (IItemProvider)((IItemProvider)species.getSeed().get()));
            }
        });
        this.composterChanceCache.clear();
    }
}

