/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.resources.loader;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.resource.loading.preparation.JsonRegistryResourceLoader;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.deserialisation.JsonHelper;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.google.gson.JsonObject;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FamilyResourceLoader
extends JsonRegistryResourceLoader<Family> {
    private static final Logger LOGGER = LogManager.getLogger();

    public FamilyResourceLoader() {
        super(Family.REGISTRY, "families", "family");
    }

    @Override
    public void registerAppliers() {
        this.commonAppliers.register("common_species", ResourceLocation.class, (family, registryName) -> {
            registryName = TreeRegistry.processResLoc(registryName);
            Species.REGISTRY.runOnNextLock(Species.REGISTRY.generateIfValidRunnable((ResourceLocation)registryName, family::setupCommonSpecies, FamilyResourceLoader.setCommonWarn(family, registryName)));
        }).register("common_leaves", LeavesProperties.class, Family::setCommonLeaves).register("max_branch_radius", Integer.class, Family::setMaxBranchRadius);
        this.gatherDataAppliers.register("primitive_log", Block.class, Family::setPrimitiveLog).register("primitive_stripped_log", Block.class, Family::setPrimitiveStrippedLog);
        this.setupAppliers.register("primitive_log", Block.class, Family::setPrimitiveLog).register("primitive_stripped_log", Block.class, Family::setPrimitiveStrippedLog).register("stick", Item.class, Family::setStick);
        this.loadAppliers.register("generate_surface_root", Boolean.class, Family::setHasSurfaceRoot).register("generate_stripped_branch", Boolean.class, Family::setHasStrippedBranch).register("fire_proof", Boolean.class, Family::setIsFireProof);
        this.reloadAppliers.register("conifer_variants", Boolean.class, Family::setHasConiferVariants).register("primary_thickness", Integer.class, Family::setPrimaryThickness).register("secondary_thickness", Integer.class, Family::setSecondaryThickness).register("branch_is_ladder", Boolean.class, Family::setBranchIsLadder).register("max_signal_depth", Integer.class, Family::setMaxSignalDepth);
        super.registerAppliers();
    }

    private static Runnable setCommonWarn(Family family, ResourceLocation registryName) {
        return () -> LOGGER.warn("Could not set common species for \"" + family + "\" as species with name  \"" + registryName + "\" was not found.");
    }

    @Override
    protected void applyLoadAppliers(JsonRegistryResourceLoader.LoadData loadData, JsonObject json) {
        this.setBranchProperties((Family)loadData.getResource(), json);
        super.applyLoadAppliers(loadData, json);
    }

    private void setBranchProperties(Family family, JsonObject json) {
        family.setProperties(JsonHelper.getBlockProperties(JsonHelper.getOrDefault(json, "branch_properties", JsonObject.class, new JsonObject()), family.getDefaultBranchMaterial(), family.getDefaultBranchMaterial().func_151565_r(), family::getDefaultBranchProperties, error -> this.logError(family.getRegistryName(), (String)error), warning -> this.logWarning(family.getRegistryName(), (String)warning)));
    }

    @Override
    protected void postLoadOnLoad(JsonRegistryResourceLoader.LoadData loadData, JsonObject json) {
        super.postLoadOnLoad(loadData, json);
        ((Family)loadData.getResource()).setupBlocks();
    }
}

