/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.resources.loader;

import com.ferreusveritas.dynamictrees.api.event.Hooks;
import com.ferreusveritas.dynamictrees.api.resource.ResourceAccessor;
import com.ferreusveritas.dynamictrees.api.resource.loading.AbstractResourceLoader;
import com.ferreusveritas.dynamictrees.api.resource.loading.ApplierResourceLoader;
import com.ferreusveritas.dynamictrees.api.resource.loading.preparation.MultiJsonResourcePreparer;
import com.ferreusveritas.dynamictrees.api.treepacks.ApplierRegistryEvent;
import com.ferreusveritas.dynamictrees.api.treepacks.PropertyApplierResult;
import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.FeatureCanceller;
import com.ferreusveritas.dynamictrees.deserialisation.DeserialisationException;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.deserialisation.JsonHelper;
import com.ferreusveritas.dynamictrees.deserialisation.JsonPropertyAppliers;
import com.ferreusveritas.dynamictrees.deserialisation.result.JsonResult;
import com.ferreusveritas.dynamictrees.deserialisation.result.Result;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.util.BiomeList;
import com.ferreusveritas.dynamictrees.util.CommonCollectors;
import com.ferreusveritas.dynamictrees.util.IgnoreThrowable;
import com.ferreusveritas.dynamictrees.util.JsonMapWrapper;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDatabase;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDatabases;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class BiomeDatabaseResourceLoader
extends AbstractResourceLoader<Iterable<JsonElement>>
implements ApplierResourceLoader<Iterable<JsonElement>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String DEFAULT_POPULATOR = "default";
    public static final String SELECT = "select";
    public static final String APPLY = "apply";
    public static final String WHITE = "white";
    public static final String CANCELLERS = "cancellers";
    private static final String METHOD = "method";
    public static final String ENTRY_APPLIERS = "entries";
    public static final String CANCELLATION_APPLIERS = "cancellations";
    private final JsonPropertyAppliers<BiomeDatabase.Entry> entryAppliers = new JsonPropertyAppliers<BiomeDatabase.Entry>(BiomeDatabase.Entry.class);
    private final JsonPropertyAppliers<BiomePropertySelectors.FeatureCancellations> cancellationAppliers = new JsonPropertyAppliers<BiomePropertySelectors.FeatureCancellations>(BiomePropertySelectors.FeatureCancellations.class);

    public BiomeDatabaseResourceLoader() {
        super(new MultiJsonResourcePreparer("world_gen"));
    }

    @Override
    public void registerAppliers() {
        ((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)this.entryAppliers.register("species", (Class)JsonElement.class, this::applySpecies)).register("density", (Class)JsonElement.class, this::applyDensity)).register("chance", (Class)JsonElement.class, this::applyChance)).register("multipass", (Class)Boolean.class, this::applyMultipass)).register("multipass", (Class)JsonObject.class, BiomeDatabase.Entry::setCustomMultipass)).register("blacklist", (Class)Boolean.class, BiomeDatabase.Entry::setBlacklisted)).register("forestness", (Class)Float.class, BiomeDatabase.Entry::setForestness)).register("subterranean", (Class)Boolean.class, BiomeDatabase.Entry::setSubterranean)).registerIfTrueApplier("reset", BiomeDatabase.Entry::reset);
        ((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)this.cancellationAppliers.register("namespace", (Class)String.class, BiomePropertySelectors.FeatureCancellations::putNamespace)).registerArrayApplier("namespaces", (Class)String.class, BiomePropertySelectors.FeatureCancellations::putNamespace)).register("type", (Class)FeatureCanceller.class, BiomePropertySelectors.FeatureCancellations::putCanceller)).registerArrayApplier("types", (Class)FeatureCanceller.class, BiomePropertySelectors.FeatureCancellations::putCanceller)).register("stage", (Class)GenerationStage.Decoration.class, BiomePropertySelectors.FeatureCancellations::putStage)).registerArrayApplier("stages", (Class)GenerationStage.Decoration.class, BiomePropertySelectors.FeatureCancellations::putStage);
        ApplierResourceLoader.postApplierEvent(new EntryApplierRegistryEvent<BiomeDatabase.Entry>(this.entryAppliers, ENTRY_APPLIERS));
        ApplierResourceLoader.postApplierEvent(new CancellationApplierRegistryEvent<BiomePropertySelectors.FeatureCancellations>(this.cancellationAppliers, CANCELLATION_APPLIERS));
    }

    private PropertyApplierResult applySpecies(BiomeDatabase.Entry entry, JsonElement jsonElement) {
        return PropertyApplierResult.from(JsonDeserialisers.SPECIES_SELECTOR.deserialise(jsonElement).ifSuccess(speciesSelector -> entry.getDatabase().setSpeciesSelector(entry.getBiome(), (BiomePropertySelectors.SpeciesSelector)speciesSelector, BiomeDatabaseResourceLoader.getOperationOrWarn(jsonElement))));
    }

    private PropertyApplierResult applyDensity(BiomeDatabase.Entry entry, JsonElement jsonElement) {
        return PropertyApplierResult.from(JsonDeserialisers.DENSITY_SELECTOR.deserialise(jsonElement).ifSuccess(densitySelector -> entry.getDatabase().setDensitySelector(entry.getBiome(), (BiomePropertySelectors.DensitySelector)densitySelector, BiomeDatabaseResourceLoader.getOperationOrWarn(jsonElement))));
    }

    private PropertyApplierResult applyChance(BiomeDatabase.Entry entry, JsonElement jsonElement) {
        return PropertyApplierResult.from(JsonDeserialisers.CHANCE_SELECTOR.deserialise(jsonElement).ifSuccess(chanceSelector -> entry.getDatabase().setChanceSelector(entry.getBiome(), (BiomePropertySelectors.ChanceSelector)chanceSelector, BiomeDatabaseResourceLoader.getOperationOrWarn(jsonElement))));
    }

    private void applyMultipass(BiomeDatabase.Entry entry, Boolean multipass) {
        if (!multipass.booleanValue()) {
            return;
        }
        entry.enableDefaultMultipass();
    }

    public static BiomeDatabase.Operation getOperationOrWarn(JsonElement jsonElement) {
        return BiomeDatabaseResourceLoader.getOperation(jsonElement).orElse(BiomeDatabase.Operation.REPLACE, arg_0 -> ((Logger)LOGGER).error(arg_0), arg_0 -> ((Logger)LOGGER).warn(arg_0));
    }

    private static Result<BiomeDatabase.Operation, JsonElement> getOperation(JsonElement input) {
        return JsonDeserialisers.JSON_OBJECT.deserialise(input).removeError().map(jsonObject -> jsonObject.has(METHOD) ? jsonObject.get(METHOD) : null).map(JsonDeserialisers.OPERATION::deserialise).orElseApply(error -> JsonResult.failure(input, "Error getting operation (defaulting to replace): " + error), JsonResult.success(input, BiomeDatabase.Operation.REPLACE));
    }

    @Override
    public void applyOnSetup(ResourceAccessor<Iterable<JsonElement>> resourceAccessor, IResourceManager resourceManager) {
        BiomeDatabases.reset();
        if (this.isWorldGenDisabled()) {
            return;
        }
        Hooks.onAddFeatureCancellers();
        this.readCancellers(resourceAccessor.filtered(this::isDefaultPopulator).map(this::toLinkedList));
    }

    private void readCancellers(ResourceAccessor<Deque<JsonElement>> defaultPopulators) {
        this.readModCancellers(defaultPopulators);
        this.readTreePackCancellers(defaultPopulators);
    }

    private void readModCancellers(ResourceAccessor<Deque<JsonElement>> defaultPopulators) {
        defaultPopulators.getAllResources().forEach(defaultPopulator -> this.readCancellers(defaultPopulator.getLocation(), (JsonElement)((Deque)defaultPopulator.getResource()).pollFirst()));
    }

    private void readTreePackCancellers(ResourceAccessor<Deque<JsonElement>> defaultPopulators) {
        defaultPopulators.getAllResources().forEach(defaultPopulator -> ((Deque)defaultPopulator.getResource()).forEach(json -> this.readCancellers(defaultPopulator.getLocation(), (JsonElement)json)));
    }

    private void readCancellers(ResourceLocation location, JsonElement json) {
        LOGGER.debug("Reading cancellers from Json biome populator \"{}\".", (Object)location);
        try {
            JsonResult.forInput(json).mapEachIfArray(JsonObject.class, object -> {
                try {
                    this.readCancellersInSection(location, (JsonObject)object);
                }
                catch (IgnoreThrowable ignoreThrowable) {
                    // empty catch block
                }
                return PropertyApplierResult.success();
            }).forEachWarning(warning -> LOGGER.warn("Warning whilst loading cancellers from populator \"{}\": {}", (Object)location, warning)).orElseThrow();
        }
        catch (DeserialisationException e) {
            LOGGER.error("Error whilst loading cancellers from populator \"{}\": {}", (Object)location, (Object)e.getMessage());
        }
    }

    private void readCancellersInSection(ResourceLocation location, JsonObject json) throws DeserialisationException, IgnoreThrowable {
        Consumer<String> errorConsumer = error -> LOGGER.error("Error loading populator \"{}\": {}", (Object)location, error);
        Consumer<String> warningConsumer = warning -> LOGGER.warn("Warning whilst loading populator \"{}\": {}", (Object)location, warning);
        JsonHelper.throwIfShouldNotLoad(json);
        BiomeList biomes = this.collectBiomes(json, warningConsumer);
        if (biomes.isEmpty()) {
            this.warnNoBiomesSelected(json);
            return;
        }
        JsonResult.forInput((JsonElement)json).mapIfContains(CANCELLERS, JsonObject.class, cancellerObject -> this.applyCanceller(location, errorConsumer, warningConsumer, biomes, (JsonObject)cancellerObject), PropertyApplierResult.success()).forEachWarning(warningConsumer).orElseThrow();
    }

    private BiomeList collectBiomes(JsonObject json, Consumer<String> warningConsumer) throws DeserialisationException {
        return (BiomeList)JsonResult.forInput((JsonElement)json).mapIfContains(SELECT, BiomeList.class, list -> list).forEachWarning(warningConsumer).orElseThrow();
    }

    private PropertyApplierResult applyCanceller(ResourceLocation location, Consumer<String> errorConsumer, Consumer<String> warningConsumer, BiomeList biomes, JsonObject json) {
        BiomePropertySelectors.FeatureCancellations cancellations = new BiomePropertySelectors.FeatureCancellations();
        this.applyCancellationAppliers(location, json, cancellations);
        cancellations.putDefaultStagesIfEmpty();
        BiomeDatabase.Operation operation = JsonResult.forInput((JsonElement)json).mapIfContains(METHOD, BiomeDatabase.Operation.class, op -> op, BiomeDatabase.Operation.REPLACE).forEachWarning(warningConsumer).orElse(BiomeDatabase.Operation.REPLACE, errorConsumer, warningConsumer);
        if (operation == BiomeDatabase.Operation.REPLACE) {
            this.replaceCancellationsWith(cancellations, biomes);
        } else {
            this.addCancellationsTo(cancellations, biomes);
        }
        return PropertyApplierResult.success();
    }

    private void applyCancellationAppliers(ResourceLocation location, JsonObject json, BiomePropertySelectors.FeatureCancellations cancellations) {
        this.cancellationAppliers.applyAll(new JsonMapWrapper(json), cancellations).forEachErrorWarning(error -> LOGGER.error("Error whilst applying feature cancellations in \"{}\" populator: {}", (Object)location, error), warning -> LOGGER.warn("Warning whilst applying feature cancellations in \"{}\" populator: {}", (Object)location, warning));
    }

    private void replaceCancellationsWith(BiomePropertySelectors.FeatureCancellations cancellations, List<Biome> biomes) {
        biomes.forEach(biome -> {
            BiomePropertySelectors.FeatureCancellations currentCancellations = BiomeDatabases.getDefault().getEntry((Biome)biome).getFeatureCancellations();
            currentCancellations.reset();
            currentCancellations.addAllFrom(cancellations);
        });
    }

    private void addCancellationsTo(BiomePropertySelectors.FeatureCancellations cancellations, List<Biome> biomes) {
        biomes.forEach(biome -> {
            BiomePropertySelectors.FeatureCancellations currentCancellations = BiomeDatabases.getDefault().getEntry((Biome)biome).getFeatureCancellations();
            currentCancellations.addAllFrom(cancellations);
        });
    }

    @Override
    public void applyOnReload(ResourceAccessor<Iterable<JsonElement>> resourceAccessor, IResourceManager resourceManager) {
        BiomeDatabases.reset();
        if (this.isWorldGenDisabled()) {
            return;
        }
        this.readPopulators(resourceAccessor.filtered(this::isDefaultPopulator).map(this::toLinkedList));
        this.readDimensionalPopulators(resourceAccessor.filtered(resource -> !this.isDefaultPopulator((ResourceLocation)resource)).map(this::toLinkedList));
    }

    private boolean isWorldGenDisabled() {
        return (Boolean)DTConfigs.WORLD_GEN.get() == false;
    }

    private void readPopulators(ResourceAccessor<Deque<JsonElement>> resourceAccessor) {
        Hooks.onPopulateDefaultDatabase();
        this.readModPopulators(BiomeDatabases.getDefault(), resourceAccessor);
        this.readTreePackPopulators(BiomeDatabases.getDefault(), resourceAccessor);
    }

    private void readModPopulators(BiomeDatabase database, ResourceAccessor<Deque<JsonElement>> resourceAccessor) {
        resourceAccessor.getAllResources().forEach(defaultPopulator -> this.readPopulator(database, defaultPopulator.getLocation(), (JsonElement)((Deque)defaultPopulator.getResource()).pollFirst()));
    }

    private void readTreePackPopulators(BiomeDatabase database, ResourceAccessor<Deque<JsonElement>> resourceAccessor) {
        resourceAccessor.getAllResources().forEach(defaultPopulator -> ((Deque)defaultPopulator.getResource()).forEach(jsonElement -> this.readPopulator(database, defaultPopulator.getLocation(), (JsonElement)jsonElement)));
    }

    private void readDimensionalPopulators(ResourceAccessor<Deque<JsonElement>> resourceAccessor) {
        Hooks.onPopulateDimensionalDatabases();
        this.readDimensionalModPopulators(resourceAccessor);
        this.readDimensionalTreePackPopulators(resourceAccessor);
    }

    private void readDimensionalModPopulators(ResourceAccessor<Deque<JsonElement>> resourceAccessor) {
        resourceAccessor.getAllResources().forEach(dimensionalPopulator -> this.readDimensionalPopulator(dimensionalPopulator.getLocation(), (JsonElement)((Deque)dimensionalPopulator.getResource()).pollFirst()));
    }

    private void readDimensionalTreePackPopulators(ResourceAccessor<Deque<JsonElement>> resourceAccessor) {
        resourceAccessor.getAllResources().forEach(dimensionalPopulator -> ((Deque)dimensionalPopulator.getResource()).forEach(json -> this.readDimensionalPopulator(dimensionalPopulator.getLocation(), (JsonElement)json)));
    }

    private void readDimensionalPopulator(ResourceLocation dimensionLocation, JsonElement dimensionalPopulator) {
        this.readPopulator(BiomeDatabases.getOrCreateDimensional(dimensionLocation), dimensionLocation, dimensionalPopulator);
    }

    private void readPopulator(BiomeDatabase database, ResourceLocation location, JsonElement json) {
        LOGGER.debug("Loading Json biome populator \"{}\".", (Object)location);
        try {
            JsonResult.forInput(json).mapEachIfArray(JsonObject.class, object -> {
                this.readPopulatorSection(database, location, (JsonObject)object);
                return PropertyApplierResult.success();
            }).forEachWarning(warning -> LOGGER.warn("Warning whilst loading populator \"{}\": {}", (Object)location, warning)).orElseThrow();
        }
        catch (DeserialisationException e) {
            LOGGER.error("Error loading populator \"{}\": {}", (Object)location, (Object)e.getMessage());
        }
    }

    private void readPopulatorSection(BiomeDatabase database, ResourceLocation location, JsonObject json) throws DeserialisationException {
        BiomeList biomes = this.collectBiomes(json, warning -> LOGGER.warn("Warning whilst loading populator \"{}\": {}", (Object)location, warning));
        if (biomes.isEmpty()) {
            this.warnNoBiomesSelected(json);
            return;
        }
        JsonResult.forInput((JsonElement)json).mapIfContains(APPLY, JsonObject.class, applyObject -> {
            biomes.forEach(biome -> this.entryAppliers.applyAll(new JsonMapWrapper((JsonObject)applyObject), database.getEntry((Biome)biome)));
            return PropertyApplierResult.success();
        }, PropertyApplierResult.success()).elseMapIfContains(WHITE, String.class, type -> {
            this.applyWhite(database, location, biomes, (String)type);
            return PropertyApplierResult.success();
        }, PropertyApplierResult.success()).forEachWarning(warning -> LOGGER.warn("Warning whilst loading populator \"{}\": {}", (Object)location, warning)).orElseThrow();
    }

    private void warnNoBiomesSelected(JsonObject json) {
        if (this.noBiomesSelectedWarningNotSuppressed(json)) {
            LogManager.getLogger().warn("Could not get any biomes from selector:\n" + json.get(SELECT));
        }
    }

    private boolean noBiomesSelectedWarningNotSuppressed(JsonObject json) {
        JsonElement suppress = json.get("suppress_none_selected");
        return suppress == null || !suppress.isJsonPrimitive() || !suppress.getAsJsonPrimitive().isBoolean() || !suppress.getAsJsonPrimitive().getAsBoolean();
    }

    private void applyWhite(BiomeDatabase database, ResourceLocation location, BiomeList biomes, String type) throws DeserialisationException {
        if (type.equalsIgnoreCase("all")) {
            database.getAllEntries().forEach(entry -> entry.setBlacklisted(false));
        } else if (type.equalsIgnoreCase("selected")) {
            biomes.forEach(biome -> database.getEntry((Biome)biome).setBlacklisted(false));
        } else {
            throw new DeserialisationException("Unknown type for whitelist in populator \"" + location + "\": \"" + type + "\".");
        }
    }

    private boolean isDefaultPopulator(ResourceLocation key) {
        return key.func_110623_a().equals(DEFAULT_POPULATOR);
    }

    private LinkedList<JsonElement> toLinkedList(Iterable<JsonElement> elements) {
        return StreamSupport.stream(elements.spliterator(), false).collect(CommonCollectors.toLinkedList());
    }

    public static final class CancellationApplierRegistryEvent<O>
    extends ApplierRegistryEvent<O, JsonElement> {
        public CancellationApplierRegistryEvent(JsonPropertyAppliers<O> appliers, String identifier) {
            super(appliers, identifier);
        }
    }

    public static final class EntryApplierRegistryEvent<O>
    extends ApplierRegistryEvent<O, JsonElement> {
        public EntryApplierRegistryEvent(JsonPropertyAppliers<O> appliers, String identifier) {
            super(appliers, identifier);
        }
    }
}

