/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.resources;

import com.ferreusveritas.dynamictrees.api.resource.TreeResourcePack;
import com.ferreusveritas.dynamictrees.util.CommonCollectors;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourcePack;
import net.minecraft.resources.ResourcePackFileNotFoundException;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;

public class FlatTreeResourcePack
extends ResourcePack
implements TreeResourcePack {
    protected final Path path;

    public FlatTreeResourcePack(Path path) {
        super(new File("dummy"));
        this.path = path;
    }

    public InputStream func_195761_a(@Nullable ResourcePackType type, ResourceLocation location) throws IOException {
        Path path = this.getPath(location.func_110624_b(), location.func_110623_a());
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("Could not find tree resource for path '" + path + "'.");
        }
        return Files.newInputStream(path, StandardOpenOption.READ);
    }

    protected InputStream func_195766_a(String resourcePath) throws IOException {
        throw new ResourcePackFileNotFoundException(this.field_195771_a, resourcePath);
    }

    protected boolean func_195768_c(String resourcePath) {
        return false;
    }

    public Collection<ResourceLocation> func_225637_a_(@Nullable ResourcePackType type, String namespace, String pathIn, int maxDepth, Predicate<String> filter) {
        try {
            Path root = this.getPath(namespace);
            Path inputPath = root.getFileSystem().getPath(pathIn, new String[0]);
            return Files.walk(root, new FileVisitOption[0]).map(path -> root.relativize(path.toAbsolutePath())).filter(path -> path.getNameCount() <= maxDepth).filter(path -> !path.toString().endsWith(".mcmeta")).filter(path -> path.startsWith(inputPath)).filter(path -> filter.test(path.getFileName().toString())).map(path -> new ResourceLocation(namespace, Joiner.on((char)'/').join((Iterable)path))).collect(CommonCollectors.toAlternateLinkedSet());
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public Set<String> func_195759_a(@Nullable ResourcePackType type) {
        try {
            Path root = this.getPath(new String[0]);
            return Files.walk(root, 1, new FileVisitOption[0]).map(path -> root.relativize(path.toAbsolutePath())).filter(path -> path.getNameCount() > 0).map(p -> p.toString().replaceAll("/$", "")).filter(s -> !s.isEmpty()).collect(CommonCollectors.toLinkedSet());
        }
        catch (IOException e) {
            return Collections.emptySet();
        }
    }

    protected Path getPath(String ... paths) {
        return this.path.getFileSystem().getPath(this.path.toString(), paths);
    }

    public void close() {
    }
}

