/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models.loaders;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.models.geometry.BranchBlockModelGeometry;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IModelLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class BranchBlockModelLoader
implements IModelLoader<BranchBlockModelGeometry> {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final String TEXTURES = "textures";
    private static final String BARK = "bark";
    private static final String RINGS = "rings";

    public void func_195410_a(IResourceManager resourceManager) {
    }

    public BranchBlockModelGeometry read(JsonDeserializationContext deserializationContext, JsonObject modelObject) {
        JsonObject textures = this.getTexturesObject(modelObject);
        ResourceLocation familyResLoc = this.getResLoc(modelObject);
        return this.getModelGeometry(this.getBarkResLoc(textures), this.getRingsResLoc(textures), familyResLoc == null ? null : TreeRegistry.processResLoc(familyResLoc));
    }

    protected JsonObject getTexturesObject(JsonObject modelContents) {
        if (!modelContents.has(TEXTURES) || !modelContents.get(TEXTURES).isJsonObject()) {
            this.throwRequiresElement(TEXTURES, "Json Object");
        }
        return modelContents.getAsJsonObject(TEXTURES);
    }

    protected ResourceLocation getBarkResLoc(JsonObject textureObject) {
        return this.getTextureLocation(textureObject, BARK);
    }

    protected ResourceLocation getRingsResLoc(JsonObject textureObject) {
        return this.getTextureLocation(textureObject, RINGS);
    }

    @Nullable
    protected ResourceLocation getResLoc(JsonObject object) {
        try {
            return this.getResLocOrThrow(this.getOrThrow(object, "family"));
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    protected ResourceLocation getTextureLocation(JsonObject textureObject, String textureElement) {
        try {
            return this.getResLocOrThrow(this.getOrThrow(textureObject, textureElement));
        }
        catch (RuntimeException e) {
            LOGGER.error("{} missing or did not have valid \"{}\" texture location element, using missing texture.", (Object)this.getModelTypeName(), (Object)textureElement);
            return MissingTextureSprite.func_195675_b();
        }
    }

    protected String getOrThrow(JsonObject jsonObject, String identifier) {
        if (jsonObject.get(identifier) == null || !jsonObject.get(identifier).isJsonPrimitive() || !jsonObject.get(identifier).getAsJsonPrimitive().isString()) {
            this.throwRequiresElement(identifier, "String");
        }
        return jsonObject.get(identifier).getAsString();
    }

    protected void throwRequiresElement(String element, String expectedType) {
        throw new RuntimeException(this.getModelTypeName() + " requires a valid \"" + element + "\" element of type " + expectedType + ".");
    }

    protected ResourceLocation getResLocOrThrow(String resLocStr) {
        try {
            return new ResourceLocation(resLocStr);
        }
        catch (ResourceLocationException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getModelTypeName() {
        return "Branch";
    }

    protected BranchBlockModelGeometry getModelGeometry(ResourceLocation barkResLoc, ResourceLocation ringsResLoc, @Nullable ResourceLocation familyResLoc) {
        return new BranchBlockModelGeometry(barkResLoc, ringsResLoc, familyResLoc, false);
    }
}

