/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models.geometry;

import com.ferreusveritas.dynamictrees.client.thickrings.ThickRingTextureManager;
import com.ferreusveritas.dynamictrees.models.bakedmodels.BasicBranchBlockBakedModel;
import com.ferreusveritas.dynamictrees.models.bakedmodels.ThickBranchBlockBakedModel;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.geometry.IModelGeometry;

@OnlyIn(value=Dist.CLIENT)
public class BranchBlockModelGeometry
implements IModelGeometry<BranchBlockModelGeometry> {
    protected final Set<ResourceLocation> textures = new HashSet<ResourceLocation>();
    protected final ResourceLocation barkResLoc;
    protected final ResourceLocation ringsResLoc;
    protected final boolean forceThickness;
    protected ResourceLocation familyResLoc;
    protected Family family;
    protected ResourceLocation thickRingsResLoc;

    public BranchBlockModelGeometry(@Nullable ResourceLocation barkResLoc, @Nullable ResourceLocation ringsResLoc, @Nullable ResourceLocation familyResLoc, boolean forceThickness) {
        this.barkResLoc = barkResLoc;
        this.ringsResLoc = ringsResLoc;
        this.familyResLoc = familyResLoc;
        this.forceThickness = forceThickness;
        this.addTextures(barkResLoc, ringsResLoc);
    }

    protected void addTextures(ResourceLocation ... textureResourceLocations) {
        for (ResourceLocation resourceLocation : textureResourceLocations) {
            if (resourceLocation == null) continue;
            this.textures.add(resourceLocation);
        }
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        if (!this.useThickModel(this.setFamily(modelLocation))) {
            return new BasicBranchBlockBakedModel(modelLocation, this.barkResLoc, this.ringsResLoc);
        }
        return new ThickBranchBlockBakedModel(modelLocation, this.barkResLoc, this.ringsResLoc, this.thickRingsResLoc);
    }

    private ResourceLocation setFamilyResLoc(ResourceLocation modelResLoc) {
        if (this.familyResLoc == null) {
            this.familyResLoc = new ResourceLocation(modelResLoc.func_110624_b(), modelResLoc.func_110623_a().replace("block/", "").replace("_branch", "").replace("stripped_", ""));
        }
        return this.familyResLoc;
    }

    private Family setFamily(ResourceLocation modelResLoc) {
        if (this.family == null) {
            this.family = (Family)Family.REGISTRY.get(this.setFamilyResLoc(modelResLoc));
        }
        return this.family;
    }

    private boolean useThickModel(Family family) {
        return this.forceThickness || family.isThick();
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        if (this.thickRingsResLoc == null && this.useThickModel(this.setFamily(new ResourceLocation(owner.getModelName())))) {
            this.thickRingsResLoc = ThickRingTextureManager.addRingTextureLocation(this.ringsResLoc);
            this.addTextures(this.thickRingsResLoc);
        }
        return this.textures.stream().map(resourceLocation -> new RenderMaterial(AtlasTexture.field_110575_b, resourceLocation)).collect(Collectors.toList());
    }
}

