/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models.bakedmodels;

import com.ferreusveritas.dynamictrees.blocks.branches.SurfaceRootBlock;
import com.ferreusveritas.dynamictrees.client.ModelUtils;
import com.ferreusveritas.dynamictrees.models.bakedmodels.BranchBlockBakedModel;
import com.ferreusveritas.dynamictrees.models.modeldata.RootModelConnections;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.RootConnections;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class RootBlockBakedModel
extends BranchBlockBakedModel {
    private TextureAtlasSprite barkTexture;
    private final IBakedModel[][] sleeves = new IBakedModel[4][7];
    private final IBakedModel[][] cores = new IBakedModel[2][8];
    private final IBakedModel[][] verts = new IBakedModel[4][8];

    public RootBlockBakedModel(ResourceLocation modelResLoc, ResourceLocation barkResLoc) {
        super(modelResLoc, barkResLoc, null);
    }

    @Override
    public void setupModels() {
        this.barkTexture = ModelUtils.getTexture(this.barkResLoc);
        for (int r = 0; r < 8; ++r) {
            int radius = r + 1;
            if (radius < 8) {
                for (Direction dir : CoordUtils.HORIZONTALS) {
                    int horIndex = dir.func_176736_b();
                    this.sleeves[horIndex][r] = this.bakeSleeve(radius, dir);
                    this.verts[horIndex][r] = this.bakeVert(radius, dir);
                }
            }
            this.cores[0][r] = this.bakeCore(radius, Direction.Axis.Z, this.barkTexture);
            this.cores[1][r] = this.bakeCore(radius, Direction.Axis.X, this.barkTexture);
        }
    }

    public int getRadialHeight(int radius) {
        return radius * 2;
    }

    public IBakedModel bakeSleeve(int radius, Direction dir) {
        boolean sleeveNegative;
        int radialHeight = this.getRadialHeight(radius);
        int dradius = radius * 2;
        int halfSize = (16 - dradius) / 2;
        int halfSizeX = dir.func_82601_c() != 0 ? halfSize : dradius;
        int halfSizeZ = dir.func_82599_e() != 0 ? halfSize : dradius;
        int move = 16 - halfSize;
        int centerX = 16 + dir.func_82601_c() * move;
        int centerZ = 16 + dir.func_82599_e() * move;
        Vector3f posFrom = new Vector3f((float)((centerX - halfSizeX) / 2), 0.0f, (float)((centerZ - halfSizeZ) / 2));
        Vector3f posTo = new Vector3f((float)((centerX + halfSizeX) / 2), (float)radialHeight, (float)((centerZ + halfSizeZ) / 2));
        boolean bl = sleeveNegative = dir.func_176743_c() == Direction.AxisDirection.NEGATIVE;
        if (dir.func_176740_k() == Direction.Axis.Z) {
            sleeveNegative = !sleeveNegative;
        }
        EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
        for (Direction face : Direction.values()) {
            if (dir.func_176734_d() == face) continue;
            BlockFaceUV uvface = null;
            if (face.func_176740_k().func_176722_c()) {
                boolean facePositive = face.func_176743_c() == Direction.AxisDirection.POSITIVE;
                uvface = new BlockFaceUV(new float[]{facePositive ? (float)(16 - radialHeight) : 0.0f, sleeveNegative ? 16 - halfSize : 0, facePositive ? 16.0f : (float)radialHeight, sleeveNegative ? 16 : halfSize}, ModelUtils.getFaceAngle(dir.func_176740_k(), face));
            } else {
                uvface = new BlockFaceUV(new float[]{8 - radius, sleeveNegative ? (float)(16 - halfSize) : 0.0f, 8 + radius, sleeveNegative ? 16.0f : (float)halfSize}, ModelUtils.getFaceAngle(dir.func_176740_k(), face));
            }
            if (uvface == null) continue;
            mapFacesIn.put(face, new BlockPartFace(null, -1, null, uvface));
        }
        BlockPart part = new BlockPart(posFrom, posTo, (Map)mapFacesIn, null, true);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder((IModelConfiguration)this.blockModel.customData, ItemOverrideList.field_188022_a).func_177646_a(this.barkTexture);
        for (Map.Entry e : part.field_178240_c.entrySet()) {
            Direction face = (Direction)e.getKey();
            builder.func_177650_a(face, ModelUtils.makeBakedQuad(part, (BlockPartFace)e.getValue(), this.barkTexture, face, ModelRotation.X0_Y0, this.modelResLoc));
        }
        return builder.func_177645_b();
    }

    private IBakedModel bakeVert(int radius, Direction dir) {
        int radialHeight = this.getRadialHeight(radius);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder((IModelConfiguration)this.blockModel.customData, ItemOverrideList.field_188022_a).func_177646_a(this.barkTexture);
        AxisAlignedBB partBoundary = new AxisAlignedBB((double)(8 - radius), (double)radialHeight, (double)(8 - radius), (double)(8 + radius), (double)(16 + radialHeight), (double)(8 + radius)).func_72317_d((double)(dir.func_82601_c() * 7), 0.0, (double)(dir.func_82599_e() * 7));
        for (int i = 0; i < 2; ++i) {
            AxisAlignedBB pieceBoundary = partBoundary.func_191500_a(new AxisAlignedBB(0.0, 0.0, 0.0, 16.0, 16.0, 16.0).func_72317_d(0.0, (double)(16 * i), 0.0));
            for (Direction face : Direction.values()) {
                EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
                BlockFaceUV uvface = new BlockFaceUV(ModelUtils.modUV(ModelUtils.getUVs(pieceBoundary, face)), ModelUtils.getFaceAngle(Direction.Axis.Y, face));
                mapFacesIn.put(face, new BlockPartFace(null, -1, null, uvface));
                Vector3f[] limits = ModelUtils.AABBLimits(pieceBoundary);
                BlockPart part = new BlockPart(limits[0], limits[1], (Map)mapFacesIn, null, true);
                builder.func_177650_a(face, ModelUtils.makeBakedQuad(part, (BlockPartFace)part.field_178240_c.get(face), this.barkTexture, face, ModelRotation.X0_Y0, this.modelResLoc));
            }
        }
        return builder.func_177645_b();
    }

    public IBakedModel bakeCore(int radius, Direction.Axis axis, TextureAtlasSprite icon) {
        int radialHeight = this.getRadialHeight(radius);
        Vector3f posFrom = new Vector3f((float)(8 - radius), 0.0f, (float)(8 - radius));
        Vector3f posTo = new Vector3f((float)(8 + radius), (float)radialHeight, (float)(8 + radius));
        EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
        for (Direction face : Direction.values()) {
            BlockFaceUV uvface;
            if (face.func_176740_k().func_176722_c()) {
                boolean positive = face.func_176743_c() == Direction.AxisDirection.POSITIVE;
                uvface = new BlockFaceUV(new float[]{positive ? (float)(16 - radialHeight) : 0.0f, 8 - radius, positive ? 16.0f : (float)radialHeight, 8 + radius}, ModelUtils.getFaceAngle(axis, face));
            } else {
                uvface = new BlockFaceUV(new float[]{8 - radius, 8 - radius, 8 + radius, 8 + radius}, ModelUtils.getFaceAngle(axis, face));
            }
            mapFacesIn.put(face, new BlockPartFace(null, -1, null, uvface));
        }
        BlockPart part = new BlockPart(posFrom, posTo, (Map)mapFacesIn, null, true);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder((IModelConfiguration)this.blockModel.customData, ItemOverrideList.field_188022_a).func_177646_a(icon);
        for (Map.Entry e : part.field_178240_c.entrySet()) {
            Direction face = (Direction)e.getKey();
            builder.func_177650_a(face, ModelUtils.makeBakedQuad(part, (BlockPartFace)e.getValue(), icon, face, ModelRotation.X0_Y0, this.modelResLoc));
        }
        return builder.func_177645_b();
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (side != null || state == null) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(24);
        int coreRadius = this.getRadius(state);
        int[] connections = new int[]{0, 0, 0, 0};
        RootConnections.ConnectionLevel[] connectionLevels = (RootConnections.ConnectionLevel[])RootConnections.PLACEHOLDER_CONNECTION_LEVELS.clone();
        if (extraData instanceof RootConnections) {
            RootConnections connectionData = (RootConnections)extraData;
            connections = connectionData.getAllRadii();
            connectionLevels = connectionData.getConnectionLevels();
        }
        for (int i = 0; i < connections.length; ++i) {
            connections[i] = MathHelper.func_76125_a((int)connections[i], (int)0, (int)coreRadius);
        }
        Direction sourceDir = this.getSourceDir(coreRadius, connections);
        if (sourceDir == null) {
            sourceDir = Direction.DOWN;
        }
        int coreDir = this.resolveCoreDir(sourceDir);
        boolean isGrounded = state.func_177229_b((Property)SurfaceRootBlock.GROUNDED) == Boolean.TRUE;
        for (Direction face : Direction.values()) {
            if (isGrounded) {
                quads.addAll(this.cores[coreDir][coreRadius - 1].getQuads(state, face, rand, extraData));
            }
            if (coreRadius == 8) continue;
            for (Direction connDir : CoordUtils.HORIZONTALS) {
                int idx = connDir.func_176736_b();
                int connRadius = connections[idx];
                if (connRadius <= 0) continue;
                if (isGrounded) {
                    quads.addAll(this.sleeves[idx][connRadius - 1].getQuads(state, face, rand, extraData));
                }
                if (connectionLevels[idx] != RootConnections.ConnectionLevel.HIGH) continue;
                quads.addAll(this.verts[idx][connRadius - 1].getQuads(state, face, rand, extraData));
            }
        }
        return quads;
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        Block block = state.func_177230_c();
        return block instanceof SurfaceRootBlock ? new RootModelConnections(((SurfaceRootBlock)block).getConnectionData(world, pos)) : new RootModelConnections();
    }

    protected Direction getSourceDir(int coreRadius, int[] connections) {
        int largestConnection = 0;
        Direction sourceDir = null;
        for (Direction dir : CoordUtils.HORIZONTALS) {
            int horIndex = dir.func_176736_b();
            int connRadius = connections[horIndex];
            if (connRadius <= largestConnection) continue;
            largestConnection = connRadius;
            sourceDir = dir;
        }
        if (largestConnection < coreRadius) {
            sourceDir = null;
        }
        return sourceDir;
    }

    protected int resolveCoreDir(Direction dir) {
        return dir.func_176740_k() == Direction.Axis.X ? 1 : 0;
    }

    protected int getRadius(BlockState blockState) {
        return ((SurfaceRootBlock)blockState.func_177230_c()).getRadius(blockState);
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return true;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.barkTexture;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public boolean func_230044_c_() {
        return false;
    }
}

