/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models.bakedmodels;

import com.ferreusveritas.dynamictrees.client.QuadManipulator;
import com.ferreusveritas.dynamictrees.tileentity.PottedSaplingTileEntity;
import com.ferreusveritas.dynamictrees.trees.Species;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class BakedModelBlockBonsaiPot
implements IDynamicBakedModel {
    protected IBakedModel basePotModel;
    protected Map<Species, List<BakedQuad>> cachedSaplingQuads = new HashMap<Species, List<BakedQuad>>();

    public BakedModelBlockBonsaiPot(IBakedModel basePotModel) {
        this.basePotModel = basePotModel;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (side != null || state == null || !extraData.hasProperty(PottedSaplingTileEntity.SPECIES) || !extraData.hasProperty(PottedSaplingTileEntity.POT_MIMIC)) {
            return quads;
        }
        Species species = (Species)extraData.getData(PottedSaplingTileEntity.SPECIES);
        BlockState potState = (BlockState)extraData.getData(PottedSaplingTileEntity.POT_MIMIC);
        if (species == null || potState == null || !species.isValid() || !species.getSapling().isPresent()) {
            return quads;
        }
        BlockState saplingState = species.getSapling().get().func_176223_P();
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        IBakedModel potModel = dispatcher.func_184389_a(potState);
        IBakedModel saplingModel = dispatcher.func_184389_a(saplingState);
        quads.addAll(potModel.getQuads(potState, side, rand, extraData));
        quads.addAll(this.cachedSaplingQuads.computeIfAbsent(species, s -> QuadManipulator.getQuads(saplingModel, saplingState, new Vector3d(0.0, 0.25, 0.0), rand, extraData)));
        return quads;
    }

    public boolean func_177555_b() {
        return this.basePotModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return true;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.basePotModel.func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

