/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models;

import com.ferreusveritas.dynamictrees.entities.FallingTreeEntity;
import com.ferreusveritas.dynamictrees.models.FallingTreeEntityModel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FallingTreeEntityModelTrackerCache {
    private static ConcurrentMap<Integer, FallingTreeEntityModel> models = new ConcurrentHashMap<Integer, FallingTreeEntityModel>();

    public static FallingTreeEntityModel getOrCreateModel(FallingTreeEntity entity) {
        return models.computeIfAbsent(entity.func_145782_y(), e -> new FallingTreeEntityModel(entity));
    }

    public static void cleanupModels(World world, FallingTreeEntity entity) {
        models.remove(entity.func_145782_y());
        FallingTreeEntityModelTrackerCache.cleanupModels(world);
    }

    public static void cleanupModels(World world) {
        models = models.entrySet().stream().filter(map -> world.func_73045_a(((Integer)map.getKey()).intValue()) != null).collect(Collectors.toConcurrentMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

