/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.RootyBlock;
import com.ferreusveritas.dynamictrees.client.QuadManipulator;
import com.ferreusveritas.dynamictrees.entities.FallingTreeEntity;
import com.ferreusveritas.dynamictrees.models.modeldata.ModelConnections;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class FallingTreeEntityModel
extends EntityModel<FallingTreeEntity> {
    protected final List<TreeQuadData> quads;
    protected final int entityId;
    protected final Species species;

    public FallingTreeEntityModel(FallingTreeEntity entity) {
        World world = entity.func_130014_f_();
        BranchDestructionData destructionData = entity.getDestroyData();
        Species species = destructionData.species;
        this.quads = FallingTreeEntityModel.generateTreeQuads(entity);
        this.species = species;
        this.entityId = entity.func_145782_y();
    }

    public List<TreeQuadData> getQuads() {
        return this.quads;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public static int getBrightness(FallingTreeEntity entity) {
        BranchDestructionData destructionData = entity.getDestroyData();
        World world = entity.field_70170_p;
        return world.func_180495_p(destructionData.cutPos).getLightValue((IBlockReader)world, destructionData.cutPos);
    }

    public static List<TreeQuadData> generateTreeQuads(FallingTreeEntity entity) {
        ArrayList<TreeQuadData> treeQuads;
        block10: {
            BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
            BranchDestructionData destructionData = entity.getDestroyData();
            Direction cutDir = destructionData.cutDir;
            treeQuads = new ArrayList<TreeQuadData>();
            int[] connectionArray = new int[6];
            if (destructionData.getNumBranches() <= 0) break block10;
            BlockState exState = destructionData.getBranchBlockState(0);
            BlockPos rootPos = destructionData.cutPos;
            if (exState != null) {
                BlockState leafState;
                BlockPos relPos;
                RootyBlock rootyBlock;
                Species species = destructionData.species;
                BlockPos bottomPos = entity.func_233580_cy_().func_177977_b();
                BlockState bottomState = entity.field_70170_p.func_180495_p(bottomPos);
                boolean rootyBlockAdded = false;
                if (TreeHelper.isRooty(bottomState) && (rootyBlock = TreeHelper.getRooty(bottomState)) != null && rootyBlock.fallWithTree(bottomState, entity.field_70170_p, bottomPos)) {
                    IBakedModel rootyModel = dispatcher.func_184389_a(bottomState);
                    treeQuads.addAll(FallingTreeEntityModel.toTreeQuadData(QuadManipulator.getQuads(rootyModel, bottomState, new Vector3d(0.0, -1.0, 0.0), (IModelData)EmptyModelData.INSTANCE), destructionData.species.getFamily().getRootColor(bottomState, rootyBlock.getColorFromBark()), bottomState));
                    rootyBlockAdded = true;
                }
                IBakedModel branchModel = dispatcher.func_184389_a(exState);
                destructionData.getConnections(0, connectionArray);
                boolean bottomRingsAdded = false;
                if (!rootyBlockAdded && connectionArray[cutDir.func_176745_a()] > 0) {
                    BlockPos offsetPos = BlockPos.field_177992_a.func_177972_a(cutDir);
                    float offset = (float)(8 - Math.min(((BranchBlock)exState.func_177230_c()).getRadius(exState), 8)) / 16.0f;
                    treeQuads.addAll(FallingTreeEntityModel.toTreeQuadData(QuadManipulator.getQuads(branchModel, exState, new Vector3d((double)offsetPos.func_177958_n(), (double)offsetPos.func_177956_o(), (double)offsetPos.func_177952_p()).func_186678_a((double)offset), new Direction[]{null}, (IModelData)new ModelConnections(cutDir).setFamily(TreeHelper.getBranch(exState))), exState));
                    bottomRingsAdded = true;
                }
                for (int index = 0; index < destructionData.getNumBranches(); ++index) {
                    Block previousBranch = exState.func_177230_c();
                    if (!previousBranch.equals((exState = destructionData.getBranchBlockState(index)).func_177230_c())) {
                        branchModel = dispatcher.func_184389_a(exState);
                    }
                    relPos = destructionData.getBranchRelPos(index);
                    destructionData.getConnections(index, connectionArray);
                    ModelConnections modelConnections = new ModelConnections(connectionArray).setFamily(TreeHelper.getBranch(exState));
                    if (index == 0 && bottomRingsAdded) {
                        modelConnections.setForceRing(cutDir);
                    }
                    treeQuads.addAll(FallingTreeEntityModel.toTreeQuadData(QuadManipulator.getQuads(branchModel, exState, new Vector3d((double)relPos.func_177958_n(), (double)relPos.func_177956_o(), (double)relPos.func_177952_p()), (IModelData)modelConnections), exState));
                }
                HashMap<BlockPos, BlockState> leavesClusters = species.getFellingLeavesClusters(destructionData);
                if (leavesClusters != null) {
                    for (Map.Entry<BlockPos, BlockState> leafLoc : leavesClusters.entrySet()) {
                        leafState = leafLoc.getValue();
                        treeQuads.addAll(FallingTreeEntityModel.toTreeQuadData(QuadManipulator.getQuads(dispatcher.func_184389_a(leafState), leafState, new Vector3d((double)leafLoc.getKey().func_177958_n(), (double)leafLoc.getKey().func_177956_o(), (double)leafLoc.getKey().func_177952_p()), (IModelData)EmptyModelData.INSTANCE), species.leafColorMultiplier(entity.field_70170_p, rootPos.func_177971_a((Vector3i)leafLoc.getKey())), leafState));
                    }
                } else {
                    for (int index = 0; index < destructionData.getNumLeaves(); ++index) {
                        relPos = destructionData.getLeavesRelPos(index);
                        leafState = destructionData.getLeavesBlockState(index);
                        IBakedModel leavesModel = dispatcher.func_184389_a(leafState);
                        treeQuads.addAll(FallingTreeEntityModel.toTreeQuadData(QuadManipulator.getQuads(leavesModel, leafState, new Vector3d((double)relPos.func_177958_n(), (double)relPos.func_177956_o(), (double)relPos.func_177952_p()), (IModelData)EmptyModelData.INSTANCE), destructionData.getLeavesProperties(index).treeFallColorMultiplier(leafState, (IBlockDisplayReader)entity.field_70170_p, rootPos.func_177971_a((Vector3i)relPos)), leafState));
                    }
                }
            }
        }
        return treeQuads;
    }

    public void setupAnim(FallingTreeEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        for (TreeQuadData treeQuad : this.getQuads()) {
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            BakedQuad bakedQuad = treeQuad.bakedQuad;
            if (bakedQuad.func_178212_b()) {
                int color = this.species == null ? treeQuad.color : this.species.colorTreeQuads(treeQuad.color, treeQuad);
                r = (float)(color >> 16 & 0xFF) / 255.0f;
                g = (float)(color >> 8 & 0xFF) / 255.0f;
                b = (float)(color & 0xFF) / 255.0f;
            }
            if (bakedQuad.func_239287_f_()) {
                float diffuse = 0.8f;
                r *= diffuse;
                g *= diffuse;
                b *= diffuse;
            }
            buffer.func_227889_a_(matrixStack.func_227866_c_(), bakedQuad, r, g, b, packedLight, packedOverlay);
        }
    }

    public static List<TreeQuadData> toTreeQuadData(List<BakedQuad> bakedQuads, BlockState state) {
        return FallingTreeEntityModel.toTreeQuadData(bakedQuads, 0xFFFFFF, state);
    }

    public static List<TreeQuadData> toTreeQuadData(List<BakedQuad> bakedQuads, int defaultColor, BlockState state) {
        return bakedQuads.stream().map(bakedQuad -> new TreeQuadData((BakedQuad)bakedQuad, defaultColor, state)).collect(Collectors.toList());
    }

    public static final class TreeQuadData {
        public final BakedQuad bakedQuad;
        public final BlockState state;
        public final int color;

        public TreeQuadData(BakedQuad bakedQuad, int color, BlockState state) {
            this.bakedQuad = bakedQuad;
            this.state = state;
            this.color = color;
        }
    }
}

