/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.loot.entry;

import com.ferreusveritas.dynamictrees.loot.entry.DTLootEntries;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootPoolEntryType;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedList;
import net.minecraftforge.registries.ForgeRegistries;

public final class WeightedItemLootEntry
extends StandaloneLootEntry {
    private final WeightedList<Item> items;

    public WeightedItemLootEntry(WeightedList<Item> items, int weight, int quality, ILootCondition[] conditions, ILootFunction[] functions) {
        super(weight, quality, conditions, functions);
        this.items = items;
    }

    public LootPoolEntryType func_230420_a_() {
        return DTLootEntries.WEIGHTED_ITEM;
    }

    protected void func_216154_a(Consumer<ItemStack> stackConsumer, LootContext lootContext) {
        stackConsumer.accept(new ItemStack((IItemProvider)this.items.func_226318_b_(lootContext.func_216032_b())));
    }

    public static StandaloneLootEntry.Builder<?> weightedLootTableItem(WeightedList<Item> items) {
        return WeightedItemLootEntry.func_216156_a((weight, quality, conditions, functions) -> new WeightedItemLootEntry(items, weight, quality, conditions, functions));
    }

    public static class Serializer
    extends StandaloneLootEntry.Serializer<WeightedItemLootEntry> {
        public void serializeCustom(JsonObject json, WeightedItemLootEntry value, JsonSerializationContext conditions) {
            super.func_230422_a_(json, (StandaloneLootEntry)value, conditions);
            JsonObject weightedItemsJson = new JsonObject();
            ((WeightedItemLootEntry)value).items.field_220658_a.forEach(entry -> weightedItemsJson.addProperty(String.valueOf(((Item)entry.field_220651_b).getRegistryName()), (Number)entry.field_220652_c));
            json.add("items", (JsonElement)weightedItemsJson);
        }

        protected WeightedItemLootEntry deserialize(JsonObject json, JsonDeserializationContext context, int weight, int quality, ILootCondition[] conditions, ILootFunction[] functions) {
            JsonObject weightedItemsJson = JSONUtils.func_152754_s((JsonObject)json, (String)"items");
            WeightedList items = new WeightedList();
            for (Map.Entry itemEntry : weightedItemsJson.entrySet()) {
                String name = (String)itemEntry.getKey();
                Item item = (Item)Optional.ofNullable(ForgeRegistries.ITEMS.getValue(new ResourceLocation(name))).orElseThrow(() -> new JsonSyntaxException("Expected key to be an item, was unknown string '" + name + "'"));
                int itemWeight = JSONUtils.func_151215_f((JsonElement)((JsonElement)itemEntry.getValue()), (String)name);
                items.func_226313_a_((Object)item, itemWeight);
            }
            return new WeightedItemLootEntry((WeightedList<Item>)items, weight, quality, conditions, functions);
        }
    }
}

