/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.loot.entry;

import com.ferreusveritas.dynamictrees.loot.DTLootParameters;
import com.ferreusveritas.dynamictrees.loot.entry.DTLootEntries;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPoolEntryType;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public final class ItemBySpeciesLootEntry
extends StandaloneLootEntry {
    private final Map<ResourceLocation, Item> items;

    public ItemBySpeciesLootEntry(int weight, int quality, ILootCondition[] conditions, ILootFunction[] functions, Map<ResourceLocation, Item> items) {
        super(weight, quality, conditions, functions);
        this.items = items;
    }

    public LootPoolEntryType func_230420_a_() {
        return DTLootEntries.ITEM_BY_SPECIES;
    }

    protected void func_216154_a(Consumer<ItemStack> stackConsumer, LootContext context) {
        Species species = (Species)context.func_216031_c(DTLootParameters.SPECIES);
        assert (species != null);
        Item item = this.items.get(species.getRegistryName());
        if (item == null) {
            item = Items.field_190931_a;
        }
        stackConsumer.accept(new ItemStack((IItemProvider)item));
    }

    public static class Serializer
    extends StandaloneLootEntry.Serializer<ItemBySpeciesLootEntry> {
        public void serializeCustom(JsonObject json, ItemBySpeciesLootEntry value, JsonSerializationContext context) {
            super.func_230424_a_(json, (LootEntry)value, context);
            JsonObject itemsJson = new JsonObject();
            for (Map.Entry itemEntry : value.items.entrySet()) {
                itemsJson.add(((ResourceLocation)itemEntry.getKey()).toString(), (JsonElement)new JsonPrimitive(((Item)itemEntry.getValue()).getRegistryName().toString()));
            }
            json.add("name_by_species", (JsonElement)itemsJson);
        }

        protected ItemBySpeciesLootEntry deserialize(JsonObject json, JsonDeserializationContext context, int weight, int quality, ILootCondition[] conditions, ILootFunction[] functions) {
            JsonObject namesJson = JSONUtils.func_152754_s((JsonObject)json, (String)"name_by_species");
            HashMap items = Maps.newHashMap();
            for (Map.Entry itemEntry : namesJson.entrySet()) {
                items.put(new ResourceLocation((String)itemEntry.getKey()), JSONUtils.func_188172_b((JsonElement)((JsonElement)itemEntry.getValue()), (String)((String)itemEntry.getKey())));
            }
            return new ItemBySpeciesLootEntry(weight, quality, conditions, functions, items);
        }
    }
}

