/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.loot.condition;

import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.loot.DTLootParameters;
import com.ferreusveritas.dynamictrees.loot.condition.DTLootConditions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;

public final class VoluntarySeedDropChance
implements ILootCondition {
    private final float rarity;

    public VoluntarySeedDropChance(float rarity) {
        this.rarity = rarity;
    }

    public LootConditionType func_230419_b_() {
        return DTLootConditions.VOLUNTARY_SEED_DROP_CHANCE;
    }

    public boolean test(LootContext context) {
        Float seasonalSeedDropFactor = (Float)context.func_216031_c(DTLootParameters.SEASONAL_SEED_DROP_FACTOR);
        assert (seasonalSeedDropFactor != null);
        return (double)this.rarity * (Double)DTConfigs.VOLUNTARY_SEED_DROP_RATE.get() * (double)seasonalSeedDropFactor.floatValue() > (double)context.func_216032_b().nextFloat();
    }

    public static ILootCondition.IBuilder voluntarySeedDropChance() {
        return () -> new VoluntarySeedDropChance(1.0f);
    }

    public static ILootCondition.IBuilder voluntarySeedDropChance(float rarity) {
        return () -> new VoluntarySeedDropChance(rarity);
    }

    public static class Serializer
    implements ILootSerializer<VoluntarySeedDropChance> {
        public void serialize(JsonObject json, VoluntarySeedDropChance value, JsonSerializationContext context) {
            json.addProperty("rarity", (Number)Float.valueOf(value.rarity));
        }

        public VoluntarySeedDropChance deserialize(JsonObject json, JsonDeserializationContext context) {
            return new VoluntarySeedDropChance(JSONUtils.func_151221_a((JsonObject)json, (String)"rarity", (float)1.0f));
        }
    }
}

