/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.items;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.branches.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.WorldContext;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Staff
extends Item {
    public static final String HANDLE = "handle";
    public static final String COLOR = "color";
    public static final String READ_ONLY = "read_only";
    public static final String TREE = "tree";
    public static final String CODE = "code";
    public static final String USES = "uses";
    public static final String MAX_USES = "max_uses";
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public Staff() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(DTRegistries.ITEM_GROUP));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 5.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.4, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        if (state.func_177230_c() instanceof BranchBlock || state.func_177230_c() instanceof TrunkShellBlock) {
            return 64.0f;
        }
        return super.func_150893_a(stack, state);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (state.func_177230_c() instanceof BranchBlock || state.func_177230_c() instanceof TrunkShellBlock) {
            if (this.decUses(stack)) {
                stack.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        Species species;
        World world = context.func_195991_k();
        ItemStack heldStack = context.func_195999_j().func_184586_b(context.func_221531_n());
        BlockPos pos = context.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        BlockPos rootPos = TreeHelper.findRootNode(world, pos);
        TreePart treePart = TreeHelper.getTreePart(world.func_180495_p(rootPos));
        if (!this.isReadOnly(heldStack) && treePart.isRootNode() && (species = TreeHelper.getExactSpecies(world, rootPos)).isValid()) {
            if (!context.func_195999_j().func_225608_bj_()) {
                String code = new JoCode(world, rootPos, context.func_195999_j().func_174811_aO()).toString();
                this.setCode(heldStack, code);
                if (world.field_72995_K) {
                    Minecraft.func_71410_x().field_195559_v.func_197960_a(code);
                }
            }
            this.setSpecies(heldStack, species);
            return ActionResultType.SUCCESS;
        }
        species = this.getSpecies(heldStack);
        if (species.isValid() && species.isAcceptableSoil((IWorldReader)world, pos, state)) {
            species.getJoCode(this.getCode(heldStack)).setCareful(true).generate(WorldContext.create((IWorld)world), species, pos, world.func_226691_t_(pos), context.func_195999_j().func_174811_aO(), 8, SafeChunkBounds.ANY, false);
            if (this.hasMaxUses(heldStack)) {
                if (this.decUses(heldStack)) {
                    heldStack.func_190918_g(1);
                }
            } else {
                heldStack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.hasMaxUses(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double damage = (double)this.getUses(stack) / (double)this.getMaxUses(stack);
        return 1.0 - damage;
    }

    public boolean isReadOnly(ItemStack itemStack) {
        return itemStack.func_196082_o().func_74767_n(READ_ONLY);
    }

    public Staff setReadOnly(ItemStack itemStack, boolean readonly) {
        itemStack.func_196082_o().func_74757_a(READ_ONLY, readonly);
        return this;
    }

    public Staff setSpecies(ItemStack itemStack, Species species) {
        String name = species == Species.NULL_SPECIES ? "null" : species.getRegistryName().toString();
        itemStack.func_196082_o().func_74778_a(TREE, name);
        return this;
    }

    public Staff setCode(ItemStack itemStack, String code) {
        itemStack.func_196082_o().func_74778_a(CODE, code);
        return this;
    }

    public Species getSpecies(ItemStack itemStack) {
        CompoundNBT nbt = itemStack.func_196082_o();
        if (nbt.func_74764_b(TREE)) {
            return TreeRegistry.findSpecies(nbt.func_74779_i(TREE));
        }
        Species species = TreeRegistry.findSpeciesSloppy("oak");
        this.setSpecies(itemStack, species);
        return species;
    }

    public int getUses(ItemStack itemStack) {
        CompoundNBT nbt = itemStack.func_196082_o();
        if (nbt.func_74764_b(USES)) {
            return nbt.func_74762_e(USES);
        }
        int uses = this.getMaxUses(itemStack);
        this.setUses(itemStack, uses);
        return uses;
    }

    public Staff setUses(ItemStack itemStack, int value) {
        itemStack.func_196082_o().func_74768_a(USES, value);
        return this;
    }

    public int getMaxUses(ItemStack itemStack) {
        CompoundNBT nbt = itemStack.func_196082_o();
        if (nbt.func_74764_b(MAX_USES)) {
            return nbt.func_74762_e(MAX_USES);
        }
        return 0;
    }

    public Staff setMaxUses(ItemStack itemStack, int value) {
        itemStack.func_196082_o().func_74768_a(MAX_USES, value);
        return this;
    }

    public boolean hasMaxUses(ItemStack itemStack) {
        return itemStack.func_196082_o().func_74764_b(MAX_USES);
    }

    public boolean decUses(ItemStack itemStack) {
        int uses = Math.max(0, this.getUses(itemStack) - 1);
        this.setUses(itemStack, uses);
        return uses <= 0;
    }

    public int getColor(ItemStack itemStack, int tint) {
        CompoundNBT tag = itemStack.func_196082_o();
        if (tint == 0) {
            int color = 5981999;
            Species species = this.getSpecies(itemStack);
            if (tag.func_74764_b(HANDLE)) {
                try {
                    color = Color.decode(tag.func_74779_i(HANDLE)).getRGB();
                }
                catch (NumberFormatException e) {
                    tag.func_82580_o(HANDLE);
                }
            } else if (species.isValid()) {
                color = species.getFamily().woodBarkColor;
            }
            return color;
        }
        if (tint == 1) {
            int color = 65535;
            if (tag.func_74764_b(COLOR)) {
                if (tag.func_150299_b(COLOR) == 8) {
                    this.tryConvertLegacyTag(tag);
                }
                color = tag.func_74762_e(COLOR);
            }
            return color;
        }
        return -1;
    }

    @Deprecated
    private void tryConvertLegacyTag(CompoundNBT tag) {
        String color = tag.func_74779_i(COLOR);
        tag.func_82580_o(COLOR);
        try {
            tag.func_74768_a(COLOR, Color.decode(color).getRGB());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public Staff setColor(ItemStack itemStack, int color) {
        itemStack.func_196082_o().func_74768_a(COLOR, color);
        return this;
    }

    public String getCode(ItemStack itemStack) {
        String code = "P";
        if (itemStack.func_196082_o().func_74764_b(CODE)) {
            code = itemStack.func_77978_p().func_74779_i(CODE);
        } else {
            itemStack.func_77978_p().func_74778_a(CODE, code);
        }
        return code;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.dynamictrees.species", new Object[]{this.getSpecies(stack).getTextComponent()}));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.dynamictrees.jo_code", new Object[]{new JoCode(this.getCode(stack)).getTextComponent()}));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return slot == EquipmentSlotType.MAINHAND ? this.attributeModifiers : super.getAttributeModifiers(slot, stack);
    }
}

