/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.items;

import com.ferreusveritas.dynamictrees.blocks.PottedSaplingBlock;
import com.ferreusveritas.dynamictrees.event.SeedVoluntaryPlantEvent;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.LazyValue;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.WorldContext;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDatabases;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import com.ferreusveritas.dynamictrees.worldgen.JoCodeRegistry;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class Seed
extends Item
implements IPlantable {
    private static final LazyValue<Random> BACKUP_RANDOM = LazyValue.supplied(Random::new);
    public static final String FORCE_PLANT_KEY = "ForcePlant";
    public static final String LIFESPAN_KEY = "Lifespan";
    public static final String CODE_KEY = "Code";
    private final Species species;

    public Seed() {
        super(new Item.Properties());
        this.setRegistryName("null");
        this.species = Species.NULL_SPECIES;
    }

    public Seed(Species species) {
        super(new Item.Properties().func_200916_a(DTRegistries.ITEM_GROUP));
        this.species = species;
    }

    public Species getSpecies() {
        return this.species;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return this.getTimeToLive(itemStack) + 20;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entityItem) {
        if (entityItem.field_70173_aa >= entityItem.lifespan - 20) {
            World world = entityItem.field_70170_p;
            if (!world.field_72995_K) {
                ItemStack seedStack = entityItem.func_92059_d();
                BlockPos pos = new BlockPos((Vector3i)entityItem.func_233580_cy_());
                SeedVoluntaryPlantEvent seedVolEvent = new SeedVoluntaryPlantEvent(entityItem, this.getSpecies().selfOrLocationOverride((IBlockReader)world, pos), pos, this.shouldPlant(world, pos, seedStack));
                MinecraftForge.EVENT_BUS.post((Event)seedVolEvent);
                if (!seedVolEvent.isCanceled() && seedVolEvent.getWillPlant()) {
                    this.doPlanting(world, pos, null, seedStack);
                }
                seedStack.func_190920_e(0);
            }
            entityItem.func_174812_G();
        }
        return false;
    }

    public boolean doPlanting(World world, BlockPos pos, @Nullable PlayerEntity planter, ItemStack seedStack) {
        Species species = this.getSpecies().selfOrLocationOverride((IBlockReader)world, pos);
        if (species.plantSapling((IWorld)world, pos, this.getSpecies() != species)) {
            String joCode = this.getCode(seedStack, world.field_73012_v);
            if (!joCode.isEmpty()) {
                world.func_217377_a(pos, false);
                species.getJoCode(joCode).setCareful(true).generate(WorldContext.create((IWorld)world), species, pos.func_177977_b(), world.func_226691_t_(pos), planter != null ? planter.func_174811_aO() : Direction.NORTH, 8, SafeChunkBounds.ANY, false);
            }
            return true;
        }
        return false;
    }

    public boolean shouldPlant(World world, BlockPos pos, ItemStack seedStack) {
        if (this.hasForcePlant(seedStack)) {
            return true;
        }
        if (!world.func_175710_j(pos)) {
            return false;
        }
        float plantChance = (float)((double)this.getSpecies().biomeSuitability(world, pos) * (Double)DTConfigs.SEED_PLANT_RATE.get());
        if (((Boolean)DTConfigs.SEED_ONLY_FOREST.get()).booleanValue()) {
            plantChance *= BiomeDatabases.getDimensionalOrDefault(world.func_234923_W_().func_240901_a_()).getForestness(world.func_226691_t_(pos));
        }
        float accum = 1.0f;
        int count = seedStack.func_190916_E();
        while (count-- > 0) {
            accum *= 1.0f - plantChance;
        }
        plantChance = 1.0f - accum;
        return plantChance > world.field_73012_v.nextFloat();
    }

    public boolean hasForcePlant(ItemStack seedStack) {
        boolean forcePlant = false;
        if (seedStack.func_77942_o()) {
            CompoundNBT nbtData = seedStack.func_77978_p();
            assert (nbtData != null);
            forcePlant = nbtData.func_74767_n(FORCE_PLANT_KEY);
        }
        return forcePlant;
    }

    public int getTimeToLive(ItemStack seedStack) {
        int lifespan = (Integer)DTConfigs.SEED_TIME_TO_LIVE.get();
        if (seedStack.func_77942_o()) {
            CompoundNBT nbtData = seedStack.func_77978_p();
            assert (nbtData != null);
            if (nbtData.func_74764_b(LIFESPAN_KEY)) {
                lifespan = nbtData.func_74762_e(LIFESPAN_KEY);
            }
        }
        return lifespan;
    }

    public String getCode(ItemStack seedStack, Random random) {
        String joCode = "";
        if (seedStack.func_77942_o()) {
            CompoundNBT tag = seedStack.func_77978_p();
            assert (tag != null);
            if (tag.func_74764_b(CODE_KEY)) {
                JoCode code;
                if (tag.func_150299_b(CODE_KEY) == 8) {
                    joCode = tag.func_74779_i(CODE_KEY);
                } else if (tag.func_150299_b(CODE_KEY) == 3 && (code = this.getJoCodeForRadius(random, tag.func_74762_e(CODE_KEY))) != null) {
                    joCode = code.toString();
                }
            }
        }
        return joCode;
    }

    @Nullable
    private JoCode getJoCodeForRadius(Random random, int radius) {
        return JoCodeRegistry.getRandomCode(this.species.getRegistryName(), MathHelper.func_76125_a((int)radius, (int)2, (int)8), random);
    }

    public ActionResultType onItemUseFlowerPot(ItemUseContext context) {
        BlockPos pos;
        World world = context.func_195991_k();
        BlockState emptyPotState = world.func_180495_p(pos = context.func_195995_a());
        Block emptyPotBlock = emptyPotState.func_177230_c();
        if (!(emptyPotBlock instanceof FlowerPotBlock) || emptyPotState != emptyPotBlock.func_176223_P() || ((FlowerPotBlock)emptyPotBlock).func_220276_d() != Blocks.field_150350_a) {
            return ActionResultType.PASS;
        }
        PottedSaplingBlock pottingSapling = this.getSpecies().getPottedSapling();
        world.func_175656_a(pos, pottingSapling.func_176223_P());
        if (pottingSapling.setSpecies(world, pos, pottingSapling.func_176223_P(), this.getSpecies()) && pottingSapling.setPotState(world, emptyPotState, pos)) {
            PlayerEntity player = context.func_195999_j();
            if (player != null) {
                context.func_195999_j().func_195066_a(Stats.field_188088_V);
                if (!context.func_195999_j().field_71075_bZ.field_75098_d) {
                    context.func_195996_i().func_190918_g(1);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ActionResultType onItemUsePlantSeed(ItemUseContext context) {
        BlockState state = context.func_195991_k().func_180495_p(context.func_195995_a());
        BlockPos pos = context.func_195995_a();
        Direction facing = context.func_196000_l();
        if (state.func_185904_a().func_76222_j()) {
            pos = pos.func_177977_b();
            facing = Direction.UP;
        }
        if (facing == Direction.UP && context.func_195999_j() != null && context.func_195999_j().func_175151_a(pos, facing, context.func_195996_i()) && context.func_195999_j().func_175151_a(pos.func_177984_a(), facing, context.func_195996_i()) && this.doPlanting(context.func_195991_k(), pos.func_177984_a(), context.func_195999_j(), context.func_195996_i())) {
            context.func_195996_i().func_190918_g(1);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        if (this.onItemUseFlowerPot(context) == ActionResultType.SUCCESS) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (this.onItemUsePlantSeed(context) == ActionResultType.SUCCESS) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, world, tooltip, flagIn);
        if (stack.func_77942_o()) {
            String joCode = this.getCode(stack, world == null ? BACKUP_RANDOM.get() : world.field_73012_v);
            if (!joCode.isEmpty()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.dynamictrees.jo_code", new Object[]{new JoCode(joCode).getTextComponent()}));
            }
            if (this.hasForcePlant(stack)) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.dynamictrees.force_planting", new Object[]{new TranslationTextComponent("tooltip.dynamictrees.enabled").func_240700_a_(style -> style.func_240712_a_(TextFormatting.DARK_AQUA))}));
            }
            CompoundNBT nbtData = stack.func_77978_p();
            assert (nbtData != null);
            if (nbtData.func_74764_b(LIFESPAN_KEY)) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.dynamictrees.seed_life_span" + new StringTextComponent(String.valueOf(nbtData.func_74762_e(LIFESPAN_KEY))).func_240700_a_(style -> style.func_240712_a_(TextFormatting.DARK_AQUA))));
            }
        }
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        return this.getSpecies().getSapling().map(Block::func_176223_P).orElse(Blocks.field_150350_a.func_176223_P());
    }
}

