/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.items;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.substances.Emptiable;
import com.ferreusveritas.dynamictrees.api.substances.SubstanceEffect;
import com.ferreusveritas.dynamictrees.api.substances.SubstanceEffectProvider;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.systems.substances.DenudeSubstance;
import com.ferreusveritas.dynamictrees.systems.substances.DepleteSubstance;
import com.ferreusveritas.dynamictrees.systems.substances.FertilizeSubstance;
import com.ferreusveritas.dynamictrees.systems.substances.FreezeSubstance;
import com.ferreusveritas.dynamictrees.systems.substances.GrowthSubstance;
import com.ferreusveritas.dynamictrees.systems.substances.HarvestSubstance;
import com.ferreusveritas.dynamictrees.systems.substances.MegaSubstance;
import com.ferreusveritas.dynamictrees.systems.substances.TransformSubstance;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.DendroBrewingRecipe;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;

public class DendroPotion
extends Item
implements SubstanceEffectProvider,
Emptiable {
    public static final List<DendroBrewingRecipe> brewingRecipes = new ArrayList<DendroBrewingRecipe>();
    public static final String INDEX_TAG_KEY = "potion_index";
    public static final String TREE_TAG_KEY = "target";

    public DendroPotion() {
        super(new Item.Properties().func_200916_a(DTRegistries.ITEM_GROUP).func_200917_a(1));
    }

    public ItemStack applyIndexTag(ItemStack potionStack, int potionIndex) {
        potionStack.func_196082_o().func_74768_a(INDEX_TAG_KEY, potionIndex);
        return potionStack;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            for (DendroPotionType potion : DendroPotionType.values()) {
                if (!potion.isActive()) continue;
                items.add((Object)this.applyIndexTag(new ItemStack((IItemProvider)this, 1), potion.getIndex()));
            }
        }
    }

    public static DendroPotionType getPotionType(ItemStack stack) {
        return DendroPotionType.values()[stack.func_196082_o().func_74762_e(INDEX_TAG_KEY)];
    }

    @Override
    @Nullable
    public SubstanceEffect getSubstanceEffect(ItemStack itemStack) {
        switch (DendroPotion.getPotionType(itemStack)) {
            default: {
                return null;
            }
            case BURGEONING: {
                return new GrowthSubstance();
            }
            case GIGAS: {
                return new MegaSubstance();
            }
            case DEPLETION: {
                return new DepleteSubstance().setAmount(15);
            }
            case FERTILITY: {
                return new FertilizeSubstance().setAmount(15);
            }
            case PERSISTENCE: {
                return new FreezeSubstance();
            }
            case TRANSFORM: {
                return new TransformSubstance(this.getTargetSpecies(itemStack));
            }
            case HARVEST: {
                return new HarvestSubstance();
            }
            case DENUDING: 
        }
        return new DenudeSubstance();
    }

    public Species getTargetSpecies(ItemStack itemStack) {
        CompoundNBT nbtTag = itemStack.func_196082_o();
        return nbtTag.func_74764_b(TREE_TAG_KEY) ? TreeRegistry.findSpecies(nbtTag.func_74779_i(TREE_TAG_KEY)) : Species.NULL_SPECIES;
    }

    public ItemStack setTargetSpecies(ItemStack itemStack, Species species) {
        itemStack.func_196082_o().func_74778_a(TREE_TAG_KEY, species.getRegistryName().toString());
        return itemStack;
    }

    public void registerRecipes() {
        ItemStack awkwardStack = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potion.func_185168_a((String)"awkward"));
        brewingRecipes.add(this.getRecipe(awkwardStack, new ItemStack((IItemProvider)Items.field_196155_l), this.getPotionStack(DendroPotionType.BIOCHAR)));
        for (int i = 1; i < DendroPotionType.values().length; ++i) {
            DendroPotionType type = DendroPotionType.values()[i];
            if (!type.isActive()) continue;
            brewingRecipes.add(this.getRecipe(type.getIngredient(), type));
        }
        for (Species species : TreeRegistry.getPotionTransformableSpecies()) {
            brewingRecipes.add(new DendroBrewingRecipe(this.getPotionStack(DendroPotionType.TRANSFORM), species.getSeedStack(1), this.setTargetSpecies(this.getPotionStack(DendroPotionType.TRANSFORM), species)));
        }
        brewingRecipes.forEach(BrewingRecipeRegistry::addRecipe);
    }

    private DendroBrewingRecipe getRecipe(Item ingredient, DendroPotionType typeOut) {
        return this.getRecipe(new ItemStack((IItemProvider)ingredient), typeOut);
    }

    private DendroBrewingRecipe getRecipe(Block ingredient, DendroPotionType typeOut) {
        return this.getRecipe(new ItemStack((IItemProvider)ingredient), typeOut);
    }

    private DendroBrewingRecipe getRecipe(ItemStack ingredient, DendroPotionType typeOut) {
        return this.getRecipe(this.getPotionStack(typeOut.getBasePotionType()), ingredient, this.getPotionStack(typeOut));
    }

    private DendroBrewingRecipe getRecipe(ItemStack ingredientStack, ItemStack stackOut) {
        return this.getRecipe(this.getPotionStack(DendroPotionType.BIOCHAR), ingredientStack, stackOut);
    }

    private DendroBrewingRecipe getRecipe(ItemStack stackIn, ItemStack ingredientStack, ItemStack stackOut) {
        return new DendroBrewingRecipe(stackIn, ingredientStack, stackOut);
    }

    private ItemStack getPotionStack(DendroPotionType type) {
        return this.applyIndexTag(new ItemStack((IItemProvider)this), type.getIndex());
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "." + DendroPotion.getPotionType(stack).getName();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        DendroPotionType potionType = DendroPotion.getPotionType(stack);
        if (potionType != DendroPotionType.TRANSFORM || !this.getTargetSpecies(stack).isValid()) {
            tooltip.add(DendroPotion.getPotionType(stack).getDescription());
            return;
        }
        Species species = this.getTargetSpecies(stack);
        tooltip.add((ITextComponent)new TranslationTextComponent("potion.transform.description", new Object[]{species.getTextComponent()}).func_240700_a_(style -> style.func_240712_a_(TextFormatting.GRAY)));
    }

    public int getColor(ItemStack stack, int tint) {
        return tint == 0 ? DendroPotion.getPotionType(stack).getColor() : -1;
    }

    @Override
    public ItemStack getEmptyContainer() {
        return new ItemStack((IItemProvider)Items.field_151069_bo);
    }

    public static enum DendroPotionType {
        BIOCHAR(0, true, "biochar", 2564892, Items.field_196155_l),
        DEPLETION(1, true, "depletion", 7781997, Items.field_151123_aH),
        GIGAS(2, true, "gigas", 14913565, Items.field_151080_bb),
        BURGEONING(3, true, "burgeoning", 11124414, Items.field_151073_bk),
        FERTILITY(4, false, "fertility", 4903936, Items.field_196086_aW),
        PERSISTENCE(5, false, "persistence", 3709695, Items.field_221621_aW),
        TRANSFORM(6, true, "transform", 8370340, Items.field_179563_cD),
        HARVEST(7, false, "harvest", 15188324, Items.field_151060_bw),
        DENUDING(8, false, "denuding", 10780230, Items.field_151071_bq, 1);

        private final int index;
        private final boolean active;
        private final String name;
        private final int color;
        private final ItemStack ingredient;
        private final int baseIndex;

        private DendroPotionType(int index, boolean active, String name, int color, Item ingredient) {
            this(index, active, name, color, ingredient, 0);
        }

        private DendroPotionType(int index, boolean active, String name, int color, Item ingredient, int baseIndex) {
            this.index = index;
            this.active = active;
            this.name = name;
            this.color = color;
            this.ingredient = new ItemStack((IItemProvider)ingredient);
            this.baseIndex = baseIndex;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isActive() {
            return this.active;
        }

        public String getName() {
            return this.name;
        }

        public int getColor() {
            return this.color;
        }

        public ItemStack getIngredient() {
            return this.ingredient;
        }

        public ITextComponent getDescription() {
            return new TranslationTextComponent("potion." + this.name + ".description" + (this == TRANSFORM ? ".empty" : "")).func_240700_a_(style -> style.func_240712_a_(TextFormatting.GRAY));
        }

        public DendroPotionType getBasePotionType() {
            return DendroPotionType.values()[this.baseIndex];
        }
    }
}

