/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.init;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.registry.AbstractRegistry;
import com.ferreusveritas.dynamictrees.api.registry.Registries;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEvent;
import com.ferreusveritas.dynamictrees.api.registry.SimpleRegistry;
import com.ferreusveritas.dynamictrees.api.registry.TypeRegistryEvent;
import com.ferreusveritas.dynamictrees.api.worldgen.FeatureCanceller;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.leaves.PalmLeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.leaves.SolidLeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.leaves.WartProperties;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.SoilProperties;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.SpreadableSoilProperties;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.WaterSoilProperties;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.resources.Resources;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.ferreusveritas.dynamictrees.trees.Mushroom;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.families.NetherFungusFamily;
import com.ferreusveritas.dynamictrees.trees.species.NetherFungusSpecies;
import com.ferreusveritas.dynamictrees.trees.species.PalmSpecies;
import com.ferreusveritas.dynamictrees.trees.species.SwampOakSpecies;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedList;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.feature.Features;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DTTrees {
    public static final ResourceLocation NULL = DynamicTrees.resLoc("null");
    public static final ResourceLocation OAK = DynamicTrees.resLoc("oak");
    public static final ResourceLocation BIRCH = DynamicTrees.resLoc("birch");
    public static final ResourceLocation SPRUCE = DynamicTrees.resLoc("spruce");
    public static final ResourceLocation JUNGLE = DynamicTrees.resLoc("jungle");
    public static final ResourceLocation DARK_OAK = DynamicTrees.resLoc("dark_oak");
    public static final ResourceLocation ACACIA = DynamicTrees.resLoc("acacia");
    public static final ResourceLocation CRIMSON = DynamicTrees.resLoc("crimson");
    public static final ResourceLocation WARPED = DynamicTrees.resLoc("warped");

    @SubscribeEvent
    public static void registerSpecies(RegistryEvent<Species> event) {
        event.getRegistry().registerAll(new Species[]{new Mushroom(true), new Mushroom(false)});
    }

    @SubscribeEvent
    public static void registerSoilProperties(RegistryEvent<SoilProperties> event) {
        event.getRegistry().registerAll(new SoilProperties[0]);
    }

    @SubscribeEvent
    public static void registerLeavesPropertiesTypes(TypeRegistryEvent<LeavesProperties> event) {
        event.registerType(DynamicTrees.resLoc("solid"), SolidLeavesProperties.TYPE);
        event.registerType(DynamicTrees.resLoc("wart"), WartProperties.TYPE);
        event.registerType(DynamicTrees.resLoc("palm"), PalmLeavesProperties.TYPE);
    }

    @SubscribeEvent
    public static void registerFamilyTypes(TypeRegistryEvent<Family> event) {
        event.registerType(DynamicTrees.resLoc("nether_fungus"), NetherFungusFamily.TYPE);
    }

    @SubscribeEvent
    public static void registerSpeciesTypes(TypeRegistryEvent<Species> event) {
        event.registerType(DynamicTrees.resLoc("nether_fungus"), NetherFungusSpecies.TYPE);
        event.registerType(DynamicTrees.resLoc("swamp_oak"), SwampOakSpecies.TYPE);
        event.registerType(DynamicTrees.resLoc("palm"), PalmSpecies.TYPE);
    }

    @SubscribeEvent
    public static void registerSoilPropertiesTypes(TypeRegistryEvent<SoilProperties> event) {
        event.registerType(DynamicTrees.resLoc("water"), WaterSoilProperties.TYPE);
        event.registerType(DynamicTrees.resLoc("spreadable"), SpreadableSoilProperties.TYPE);
    }

    @SubscribeEvent
    public static void newRegistry(RegistryEvent.NewRegistry event) {
        List<SimpleRegistry> registries = Registries.REGISTRIES.stream().filter(registry -> registry instanceof SimpleRegistry).map(registry -> (SimpleRegistry)registry).collect(Collectors.toList());
        registries.forEach(AbstractRegistry::postRegistryEvent);
        Resources.setupTreesResourceManager();
        JsonDeserialisers.registerForgeEntryGetters();
        JsonDeserialisers.postRegistryEvent();
        Resources.MANAGER.load();
        registries.forEach(AbstractRegistry::lock);
        FeatureCanceller.REGISTRY.postRegistryEvent();
        FeatureCanceller.REGISTRY.lock();
    }

    public static void replaceNyliumFungiFeatures() {
        TreeRegistry.findSpecies(CRIMSON).getSapling().ifPresent(crimsonSapling -> TreeRegistry.findSpecies(WARPED).getSapling().ifPresent(warpedSapling -> {
            DTTrees.replaceFeatureConfigs((WeightedBlockStateProvider)Features.Configs.field_243987_k.field_227268_a_, crimsonSapling, warpedSapling);
            DTTrees.replaceFeatureConfigs((WeightedBlockStateProvider)Features.Configs.field_243988_l.field_227268_a_, crimsonSapling, warpedSapling);
        }));
    }

    private static void replaceFeatureConfigs(WeightedBlockStateProvider featureConfig, Block crimsonSapling, Block warpedSapling) {
        for (WeightedList.Entry entry : featureConfig.field_227406_b_.field_220658_a) {
            if (((BlockState)entry.field_220651_b).func_177230_c() == Blocks.field_235382_mv_) {
                entry.field_220651_b = crimsonSapling.func_176223_P();
            }
            if (((BlockState)entry.field_220651_b).func_177230_c() != Blocks.field_235373_mm_) continue;
            entry.field_220651_b = warpedSapling.func_176223_P();
        }
    }
}

