/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.init;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.cells.CellKit;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEvent;
import com.ferreusveritas.dynamictrees.api.registry.RegistryHandler;
import com.ferreusveritas.dynamictrees.api.worldgen.FeatureCanceller;
import com.ferreusveritas.dynamictrees.blocks.PottedSaplingBlock;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.branches.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.RootyBlock;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.SoilProperties;
import com.ferreusveritas.dynamictrees.cells.CellKits;
import com.ferreusveritas.dynamictrees.entities.FallingTreeEntity;
import com.ferreusveritas.dynamictrees.entities.LingeringEffectorEntity;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKits;
import com.ferreusveritas.dynamictrees.init.DTTrees;
import com.ferreusveritas.dynamictrees.items.DendroPotion;
import com.ferreusveritas.dynamictrees.items.DirtBucket;
import com.ferreusveritas.dynamictrees.items.Staff;
import com.ferreusveritas.dynamictrees.systems.BranchConnectables;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatures;
import com.ferreusveritas.dynamictrees.tileentity.PottedSaplingTileEntity;
import com.ferreusveritas.dynamictrees.tileentity.SpeciesTileEntity;
import com.ferreusveritas.dynamictrees.worldgen.DynamicTreeFeature;
import com.ferreusveritas.dynamictrees.worldgen.cancellers.FungusFeatureCanceller;
import com.ferreusveritas.dynamictrees.worldgen.cancellers.MushroomFeatureCanceller;
import com.ferreusveritas.dynamictrees.worldgen.cancellers.TreeFeatureCanceller;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.HugeFungusConfig;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DTRegistries {
    public static final ItemGroup ITEM_GROUP = new ItemGroup("dynamictrees"){

        public ItemStack func_78016_d() {
            return TreeRegistry.findSpecies(DTTrees.OAK).getSeedStack(1);
        }
    };
    public static final PottedSaplingBlock POTTED_SAPLING = new PottedSaplingBlock();
    public static final TrunkShellBlock TRUNK_SHELL = new TrunkShellBlock();
    public static final DendroPotion DENDRO_POTION = new DendroPotion();
    public static final DirtBucket DIRT_BUCKET = new DirtBucket();
    public static final Staff STAFF = new Staff();
    public static final String FALLING_TREE_ID = "falling_tree";
    public static final String LINGERING_EFFECTOR_ID = "lingering_effector";
    public static final EntityType<FallingTreeEntity> FALLING_TREE = EntityType.Builder.func_220322_a(FallingTreeEntity::new, (EntityClassification)EntityClassification.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(512).setUpdateInterval(Integer.MAX_VALUE).setCustomClientFactory((spawnEntity, world) -> new FallingTreeEntity((World)world)).func_206830_a("falling_tree");
    public static final EntityType<LingeringEffectorEntity> LINGERING_EFFECTOR = EntityType.Builder.func_220322_a(LingeringEffectorEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory((spawnEntity, world) -> new LingeringEffectorEntity((World)world, new BlockPos(spawnEntity.getPosX(), spawnEntity.getPosY(), spawnEntity.getPosZ()), null)).func_206830_a("lingering_effector");
    public static TileEntityType<SpeciesTileEntity> speciesTE;
    public static TileEntityType<PottedSaplingTileEntity> bonsaiTE;
    public static final DynamicTreeFeature DYNAMIC_TREE_FEATURE;
    public static final ConfiguredFeature<NoFeatureConfig, ?> DYNAMIC_TREE_CONFIGURED_FEATURE;
    public static final FeatureCanceller TREE_CANCELLER;
    public static final FeatureCanceller FUNGUS_CANCELLER;
    public static final FeatureCanceller MUSHROOM_CANCELLER;

    public static void setup() {
        DTRegistries.setupBlocks();
        DTRegistries.setupConnectables();
        DTRegistries.setupItems();
    }

    private static void setupBlocks() {
        RegistryHandler.addBlock(PottedSaplingBlock.REG_NAME, POTTED_SAPLING);
        RegistryHandler.addBlock(DynamicTrees.resLoc("trunk_shell"), TRUNK_SHELL);
    }

    private static void setupConnectables() {
        BranchConnectables.makeBlockConnectable(Blocks.field_226905_ma_, (state, world, pos, side) -> {
            if (side == Direction.DOWN) {
                return 1;
            }
            return 0;
        });
        BranchConnectables.makeBlockConnectable(Blocks.field_235383_mw_, (state, world, pos, side) -> {
            if (side == Direction.DOWN) {
                BlockState branchState = world.func_180495_p(pos.func_177972_a(Direction.UP));
                BranchBlock branch = TreeHelper.getBranch(branchState);
                if (branch != null) {
                    return MathHelper.func_76125_a((int)(branch.getRadius(branchState) - 1), (int)1, (int)8);
                }
                return 8;
            }
            return 0;
        });
    }

    private static void setupItems() {
        RegistryHandler.addItem(DynamicTrees.resLoc("staff"), STAFF);
        RegistryHandler.addItem(DynamicTrees.resLoc("dirt_bucket"), DIRT_BUCKET);
        RegistryHandler.addItem(DynamicTrees.resLoc("dendro_potion"), DENDRO_POTION);
    }

    @SubscribeEvent
    public static void onEntitiesRegistry(RegistryEvent.Register<EntityType<?>> entityRegistryEvent) {
        IForgeRegistry registry = entityRegistryEvent.getRegistry();
        registry.registerAll((IForgeRegistryEntry[])new EntityType[]{(EntityType)FALLING_TREE.setRegistryName(DynamicTrees.resLoc(FALLING_TREE_ID)), (EntityType)LINGERING_EFFECTOR.setRegistryName(DynamicTrees.resLoc(LINGERING_EFFECTOR_ID))});
    }

    public static void setupTileEntities() {
        Block[] rootyBlocks = (RootyBlock[])SoilProperties.REGISTRY.getAll().stream().map(SoilProperties::getBlock).filter(Optional::isPresent).map(Optional::get).distinct().toArray(RootyBlock[]::new);
        speciesTE = TileEntityType.Builder.func_223042_a(SpeciesTileEntity::new, (Block[])rootyBlocks).func_206865_a(null);
        bonsaiTE = TileEntityType.Builder.func_223042_a(PottedSaplingTileEntity::new, (Block[])new Block[]{POTTED_SAPLING}).func_206865_a(null);
    }

    @SubscribeEvent
    public static void onTileEntitiesRegistry(RegistryEvent.Register<TileEntityType<?>> tileEntityRegistryEvent) {
        DTRegistries.setupTileEntities();
        tileEntityRegistryEvent.getRegistry().register(bonsaiTE.setRegistryName(PottedSaplingBlock.REG_NAME));
        tileEntityRegistryEvent.getRegistry().register(speciesTE.setRegistryName(DynamicTrees.resLoc("tile_entity_species")));
    }

    @SubscribeEvent
    public static void onFeatureRegistry(RegistryEvent.Register<Feature<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)DYNAMIC_TREE_FEATURE);
    }

    public static void registerConfiguredFeatures() {
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)DynamicTrees.resLoc("dynamic_tree"), DYNAMIC_TREE_CONFIGURED_FEATURE);
    }

    @SubscribeEvent
    public static void onFeatureCancellerRegistry(RegistryEvent<FeatureCanceller> event) {
        event.getRegistry().registerAll(new FeatureCanceller[]{TREE_CANCELLER, FUNGUS_CANCELLER, MUSHROOM_CANCELLER});
    }

    @SubscribeEvent
    public static void onCellKitRegistry(RegistryEvent<CellKit> event) {
        CellKits.register(event.getRegistry());
    }

    @SubscribeEvent
    public static void onGrowthLogicKitRegistry(RegistryEvent<GrowthLogicKit> event) {
        GrowthLogicKits.register(event.getRegistry());
    }

    @SubscribeEvent
    public static void onGenFeatureRegistry(RegistryEvent<GenFeature> event) {
        GenFeatures.register(event.getRegistry());
    }

    static {
        DYNAMIC_TREE_FEATURE = new DynamicTreeFeature();
        DYNAMIC_TREE_CONFIGURED_FEATURE = DYNAMIC_TREE_FEATURE.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_);
        TREE_CANCELLER = new TreeFeatureCanceller<BaseTreeFeatureConfig>(DynamicTrees.resLoc("tree"), BaseTreeFeatureConfig.class);
        FUNGUS_CANCELLER = new FungusFeatureCanceller<HugeFungusConfig>(DynamicTrees.resLoc("fungus"), HugeFungusConfig.class);
        MUSHROOM_CANCELLER = new MushroomFeatureCanceller<BigMushroomFeatureConfig>(DynamicTrees.resLoc("mushroom"), BigMushroomFeatureConfig.class);
    }
}

