/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.init;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.client.ModelHelper;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.blocks.DynamicSaplingBlock;
import com.ferreusveritas.dynamictrees.blocks.FruitBlock;
import com.ferreusveritas.dynamictrees.blocks.PodBlock;
import com.ferreusveritas.dynamictrees.blocks.PottedSaplingBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.RootyBlock;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.SoilHelper;
import com.ferreusveritas.dynamictrees.client.BlockColorMultipliers;
import com.ferreusveritas.dynamictrees.client.TextureUtils;
import com.ferreusveritas.dynamictrees.entities.render.FallingTreeRenderer;
import com.ferreusveritas.dynamictrees.entities.render.LingeringEffectorRenderer;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.ferreusveritas.dynamictrees.trees.Species;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.FoliageColors;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;

public class DTClient {
    public static void clientStart() {
    }

    public static void setup() {
        DTClient.registerRenderLayers();
        DTClient.registerJsonColorMultipliers();
        DTClient.registerEntityRenderers();
        DTClient.registerColorHandlers();
        LeavesProperties.postInitClient();
        DTClient.cleanup();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void discoverWoodColors() {
        Function bakedTextureGetter = Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_);
        for (Family family : Species.REGISTRY.getAll().stream().map(Species::getFamily).distinct().collect(Collectors.toList())) {
            family.woodRingColor = 16773550;
            family.woodBarkColor = 11774329;
            if (family == Family.NULL_FAMILY) continue;
            family.getPrimitiveLog().ifPresent(branch -> {
                BlockState state = branch.func_176223_P();
                family.woodRingColor = DTClient.getFaceColor(state, Direction.DOWN, bakedTextureGetter);
                family.woodBarkColor = DTClient.getFaceColor(state, Direction.NORTH, bakedTextureGetter);
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static int getFaceColor(BlockState state, Direction face, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        List quads = model.getQuads(state, face, new Random(), (IModelData)EmptyModelData.INSTANCE);
        if (quads.isEmpty()) {
            quads = model.getQuads(state, null, new Random(), (IModelData)EmptyModelData.INSTANCE);
        }
        if (quads.isEmpty()) {
            LogManager.getLogger().warn("Could not get color of " + face + " side for " + state.func_177230_c() + "! Branch needs to be handled manually!");
            return 0;
        }
        ResourceLocation resLoc = ((BakedQuad)quads.get(0)).func_187508_a().func_195668_m();
        if (!resLoc.toString().isEmpty()) {
            TextureUtils.PixelBuffer pixelBuffer = new TextureUtils.PixelBuffer(textureGetter.apply(resLoc));
            int u = pixelBuffer.w / 16;
            TextureUtils.PixelBuffer center = new TextureUtils.PixelBuffer(u * 8, u * 8);
            pixelBuffer.blit(center, u * -8, u * -8);
            return center.averageColor();
        }
        return 0;
    }

    private static void cleanup() {
        BlockColorMultipliers.cleanUp();
    }

    private static boolean isValid(IBlockReader access, BlockPos pos) {
        return access != null && pos != null;
    }

    private static void registerRenderLayers() {
        RenderTypeLookup.setRenderLayer((Block)DTRegistries.POTTED_SAPLING, (RenderType)RenderType.func_228641_d_());
        ForgeRegistries.BLOCKS.getValues().stream().filter(block -> block instanceof DynamicSaplingBlock || block instanceof RootyBlock || block instanceof FruitBlock || block instanceof PodBlock).forEach(block -> RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228641_d_()));
    }

    private static void registerColorHandlers() {
        int white = -1;
        int magenta = 0xFF00FF;
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        for (RootyBlock roots : SoilHelper.getRootyBlocksList()) {
            blockColors.func_186722_a((state, world, pos, tintIndex) -> roots.colorMultiplier(blockColors, state, world, pos, tintIndex), new Block[]{roots});
        }
        ModelHelper.regColorHandler((Block)DTRegistries.POTTED_SAPLING, (state, access, pos, tintIndex) -> DTClient.isValid((IBlockReader)access, pos) && state.func_177230_c() instanceof PottedSaplingBlock ? DTRegistries.POTTED_SAPLING.getSpecies((IBlockReader)access, pos).saplingColorMultiplier(state, access, pos, tintIndex) : -1);
        ModelHelper.regColorHandler(DTRegistries.DENDRO_POTION, DTRegistries.DENDRO_POTION::getColor);
        ModelHelper.regColorHandler(DTRegistries.STAFF, DTRegistries.STAFF::getColor);
        for (Species species : Species.REGISTRY) {
            if (!species.getSapling().isPresent()) continue;
            ModelHelper.regColorHandler(species.getSapling().get(), (state, access, pos, tintIndex) -> DTClient.isValid((IBlockReader)access, pos) ? species.saplingColorMultiplier(state, access, pos, tintIndex) : -1);
        }
        for (DynamicLeavesBlock leaves : LeavesProperties.REGISTRY.getAll().stream().filter(lp -> lp.getDynamicLeavesBlock().isPresent()).map(lp -> lp.getDynamicLeavesBlock().get()).collect(Collectors.toSet())) {
            ModelHelper.regColorHandler((Block)leaves, (state, worldIn, pos, tintIndex) -> {
                LeavesProperties properties = ((DynamicLeavesBlock)state.func_177230_c()).getProperties(state);
                return TreeHelper.isLeaves(state.func_177230_c()) ? properties.foliageColorMultiplier(state, worldIn, pos) : 0xFF00FF;
            });
        }
    }

    private static void registerJsonColorMultipliers() {
        BlockColorMultipliers.register("birch", (state, worldIn, pos, tintIndex) -> FoliageColors.func_77469_b());
        BlockColorMultipliers.register("spruce", (state, worldIn, pos, tintIndex) -> FoliageColors.func_77466_a());
    }

    public static void registerClientEventHandlers() {
    }

    private static void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(DTRegistries.FALLING_TREE, (IRenderFactory)new FallingTreeRenderer.Factory());
        RenderingRegistry.registerEntityRenderingHandler(DTRegistries.LINGERING_EFFECTOR, (IRenderFactory)new LingeringEffectorRenderer.Factory());
    }

    private static int getFoliageColor(LeavesProperties leavesProperties, World world, BlockState blockState, BlockPos pos) {
        return leavesProperties.foliageColorMultiplier(blockState, (IBlockDisplayReader)world, pos);
    }

    private static void addDustParticle(World world, double fx, double fy, double fz, double mx, double my, double mz, BlockState blockState, float r, float g, float b) {
        if (world.field_72995_K) {
            Particle particle = Minecraft.func_71410_x().field_71452_i.func_199280_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockState), fx, fy, fz, mx, my, mz);
            assert (particle != null);
            particle.func_70538_b(r, g, b);
        }
    }

    public static void spawnParticles(World world, BasicParticleType particleType, BlockPos pos, int numParticles, Random random) {
        DTClient.spawnParticles((IWorld)world, particleType, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), numParticles, random);
    }

    public static void spawnParticles(IWorld world, BasicParticleType particleType, int x, int y, int z, int numParticles, Random random) {
        for (int i1 = 0; i1 < numParticles; ++i1) {
            double mx = random.nextGaussian() * 0.02;
            double my = random.nextGaussian() * 0.02;
            double mz = random.nextGaussian() * 0.02;
            DTClient.spawnParticle(world, particleType, (float)x + random.nextFloat(), (double)y + (double)random.nextFloat(), (double)z + (double)random.nextFloat(), mx, my, mz);
        }
    }

    public static void spawnParticle(IWorld world, BasicParticleType particleType, double x, double y, double z, double mx, double my, double mz) {
        if (world.func_201670_d()) {
            world.func_195594_a((IParticleData)particleType, x, y, z, mx, my, mz);
        }
    }

    public static void crushLeavesBlock(World world, BlockPos pos, BlockState blockState, Entity entity) {
        if (world.field_72995_K) {
            Random random = world.field_73012_v;
            TreePart treePart = TreeHelper.getTreePart(blockState);
            if (treePart instanceof DynamicLeavesBlock) {
                DynamicLeavesBlock leaves = (DynamicLeavesBlock)treePart;
                LeavesProperties leavesProperties = leaves.getProperties(blockState);
                int color = DTClient.getFoliageColor(leavesProperties, world, blockState, pos);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                for (int dz = 0; dz < 8; ++dz) {
                    for (int dy = 0; dy < 8; ++dy) {
                        for (int dx = 0; dx < 8; ++dx) {
                            if (random.nextInt(8) != 0) continue;
                            double fx = (double)pos.func_177958_n() + (double)dx / 8.0;
                            double fy = (double)pos.func_177956_o() + (double)dy / 8.0;
                            double fz = (double)pos.func_177952_p() + (double)dz / 8.0;
                            DTClient.addDustParticle(world, fx, fy, fz, 0.0, (double)random.nextFloat() * entity.func_213322_ci().field_72448_b, 0.0, blockState, r, g, b);
                        }
                    }
                }
            }
        }
    }
}

