/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.growthlogic;

import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class DarkOakLogic
extends GrowthLogicKit {
    public DarkOakLogic(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        int[] probMap = super.populateDirectionProbabilityMap(configuration, context);
        probMap[Direction.UP.func_176745_a()] = 4;
        if (!context.signal().isInTrunk()) {
            probMap[Direction.UP.func_176745_a()] = 0;
            probMap[Direction.DOWN.func_176745_a()] = 0;
            int n = context.signal().dir.ordinal();
            probMap[n] = (int)((double)probMap[n] * 0.35);
        }
        float energyRatio = (float)context.signal().delta.func_177956_o() / context.species().getEnergy(context.world(), context.pos());
        float spreadPush = energyRatio * 2.0f;
        spreadPush = Math.max(spreadPush, 1.0f);
        for (Direction dir : CoordUtils.HORIZONTALS) {
            int n = dir.ordinal();
            probMap[n] = (int)((float)probMap[n] * spreadPush);
        }
        if (context.signal().numTurns == 1 && context.signal().delta.func_218140_a(0.0, (double)context.signal().delta.func_177956_o(), 0.0, true) == 1.0) {
            for (Direction dir : CoordUtils.HORIZONTALS) {
                if (context.signal().dir == dir) continue;
                probMap[dir.ordinal()] = 0;
            }
        }
        if (context.signal().isInTrunk()) {
            for (Direction dir : CoordUtils.HORIZONTALS) {
                if (probMap[dir.ordinal()] < 7) continue;
                probMap[dir.ordinal()] = 2;
            }
            if (context.signal().delta.func_177956_o() > context.species().getLowestBranchHeight() + 5) {
                probMap[Direction.UP.ordinal()] = 0;
                context.signal().energy = 2.0f;
            }
        }
        return probMap;
    }

    @Override
    public float getEnergy(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return super.getEnergy(configuration, context) * context.species().biomeSuitability(context.world(), context.pos());
    }

    @Override
    public int getLowestBranchHeight(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return (int)((float)super.getLowestBranchHeight(configuration, context) * context.species().biomeSuitability(context.world(), context.pos()));
    }
}

