/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.event.handlers;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.blocks.DynamicSaplingBlock;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.ItemUtils;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class VanillaSaplingEventHandler {
    @SubscribeEvent
    public void onPlayerPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        BlockState state = event.getPlacedBlock();
        if (!(event.getWorld() instanceof World) || !TreeRegistry.SAPLING_REPLACERS.containsKey(state)) {
            return;
        }
        World world = (World)event.getWorld();
        BlockPos pos = event.getPos();
        Species targetSpecies = TreeRegistry.SAPLING_REPLACERS.get(state);
        Species species = targetSpecies.selfOrLocationOverride((IBlockReader)world, pos);
        world.func_217377_a(pos, false);
        if (!species.plantSapling((IWorld)world, pos, targetSpecies != species)) {
            ItemUtils.spawnItemStack(world, pos, species.getSeedStack(1));
        }
    }

    @SubscribeEvent
    public void onSaplingGrowTree(SaplingGrowTreeEvent event) {
        IWorld iWorld = event.getWorld();
        BlockPos pos = event.getPos();
        BlockState blockState = iWorld.func_180495_p(pos);
        if (!(iWorld instanceof World) || !TreeRegistry.SAPLING_REPLACERS.containsKey(blockState)) {
            return;
        }
        World world = (World)iWorld;
        Species species = TreeRegistry.SAPLING_REPLACERS.get(blockState).selfOrLocationOverride((IBlockReader)world, pos);
        world.func_217377_a(pos, false);
        event.setResult(Event.Result.DENY);
        if (species.isValid() && DynamicSaplingBlock.canSaplingStay((IWorldReader)world, species, pos)) {
            species.transitionToTree(world, pos);
        }
    }
}

