/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.event.handlers;

import com.ferreusveritas.dynamictrees.systems.poissondisc.UniversalPoissonDiscProvider;
import com.ferreusveritas.dynamictrees.util.WorldContext;
import com.ferreusveritas.dynamictrees.worldgen.TreeGenerator;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PoissonDiscEventHandler {
    public static final String CIRCLE_DATA_ID = "GTCD";

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        IWorld world = event.getWorld();
        if (!world.func_201670_d()) {
            TreeGenerator.getTreeGenerator().getCircleProvider().unloadWorld((ServerWorld)world);
        }
    }

    @SubscribeEvent
    public void onChunkDataLoad(ChunkDataEvent.Load event) {
        IWorld world = event.getWorld();
        if (world == null || world.func_201670_d()) {
            return;
        }
        byte[] circleData = event.getData().func_74770_j(CIRCLE_DATA_ID);
        UniversalPoissonDiscProvider discProvider = TreeGenerator.getTreeGenerator().getCircleProvider();
        ChunkPos chunkPos = event.getChunk().func_76632_l();
        discProvider.setChunkPoissonData(WorldContext.create((IWorld)((World)world)), chunkPos, circleData);
    }

    @SubscribeEvent
    public void onChunkDataSave(ChunkDataEvent.Save event) {
        WorldContext worldContext = WorldContext.create((IWorld)((World)event.getWorld()));
        UniversalPoissonDiscProvider discProvider = TreeGenerator.getTreeGenerator().getCircleProvider();
        IChunk chunk = event.getChunk();
        ChunkPos chunkPos = chunk.func_76632_l();
        byte[] circleData = discProvider.getChunkPoissonData(worldContext, chunkPos);
        event.getData().func_74773_a(CIRCLE_DATA_ID, circleData);
        if (chunk instanceof Chunk && !((Chunk)chunk).field_76636_d) {
            discProvider.unloadChunkPoissonData(worldContext, chunkPos);
        }
    }
}

