/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.event.handlers;

import com.ferreusveritas.dynamictrees.event.handlers.CommonEventHandler;
import com.ferreusveritas.dynamictrees.event.handlers.LeafUpdateEventHandler;
import com.ferreusveritas.dynamictrees.event.handlers.PoissonDiscEventHandler;
import com.ferreusveritas.dynamictrees.event.handlers.ServerEventHandler;
import com.ferreusveritas.dynamictrees.event.handlers.VanillaSaplingEventHandler;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.worldgen.WorldGenEventHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModList;

public final class EventHandlers {
    public static final CommonEventHandler COMMON_EVENT_HANDLER = new CommonEventHandler();
    public static final ServerEventHandler SERVER_EVENT_HANDLER = new ServerEventHandler();
    public static final LeafUpdateEventHandler LEAF_UPDATE_EVENT_HANDLER = new LeafUpdateEventHandler();
    public static final VanillaSaplingEventHandler VANILLA_SAPLING_EVENT_HANDLER = new VanillaSaplingEventHandler();
    public static final WorldGenEventHandler WORLD_GEN_EVENT_HANDLER = new WorldGenEventHandler();
    public static final PoissonDiscEventHandler POISSON_DISC_EVENT_HANDLER = new PoissonDiscEventHandler();

    public static void registerCommon() {
        MinecraftForge.EVENT_BUS.register((Object)COMMON_EVENT_HANDLER);
        MinecraftForge.EVENT_BUS.register((Object)SERVER_EVENT_HANDLER);
        if (ModList.get().isLoaded("fastleafdecay")) {
            MinecraftForge.EVENT_BUS.register((Object)LEAF_UPDATE_EVENT_HANDLER);
        }
    }

    public static void configReload() {
        EventHandlers.registerOrUnregister(VANILLA_SAPLING_EVENT_HANDLER, (Boolean)DTConfigs.REPLACE_VANILLA_SAPLING.get());
        EventHandlers.registerOrUnregister(WORLD_GEN_EVENT_HANDLER, (Boolean)DTConfigs.WORLD_GEN.get());
        EventHandlers.registerOrUnregister(POISSON_DISC_EVENT_HANDLER, (Boolean)DTConfigs.WORLD_GEN.get());
    }

    private static void registerOrUnregister(Object handler, boolean register) {
        if (register) {
            MinecraftForge.EVENT_BUS.register(handler);
        } else {
            MinecraftForge.EVENT_BUS.unregister(handler);
        }
    }
}

