/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.entities.render;

import com.ferreusveritas.dynamictrees.entities.FallingTreeEntity;
import com.ferreusveritas.dynamictrees.models.FallingTreeEntityModel;
import com.ferreusveritas.dynamictrees.models.FallingTreeEntityModelTrackerCache;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;

@OnlyIn(value=Dist.CLIENT)
public class FallingTreeRenderer
extends EntityRenderer<FallingTreeEntity> {
    protected FallingTreeRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(FallingTreeEntity entity) {
        return AtlasTexture.field_110575_b;
    }

    public void render(FallingTreeEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        super.func_225623_a_((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        if (!entity.isClientBuilt() || !entity.shouldRender()) {
            return;
        }
        this.field_76990_c.field_78724_e.func_110577_a(this.getTextureLocation(entity));
        FallingTreeEntityModel treeModel = FallingTreeEntityModelTrackerCache.getOrCreateModel(entity);
        matrixStack.func_227860_a_();
        IVertexBuilder vertexBuilder = buffer.getBuffer(RenderType.func_228638_b_((ResourceLocation)this.getTextureLocation(entity)));
        entity.currentAnimationHandler.renderTransform(entity, entityYaw, partialTicks, matrixStack);
        treeModel.func_225598_a_(matrixStack, vertexBuilder, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }

    public static class Factory
    implements IRenderFactory<FallingTreeEntity> {
        public EntityRenderer<FallingTreeEntity> createRenderFor(EntityRendererManager manager) {
            return new FallingTreeRenderer(manager);
        }
    }
}

