/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.entities.animation;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.branches.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.entities.FallingTreeEntity;
import com.ferreusveritas.dynamictrees.entities.animation.AnimationHandler;
import com.ferreusveritas.dynamictrees.entities.animation.DataAnimationHandler;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PhysicsAnimationHandler
implements AnimationHandler {
    @Override
    public String getName() {
        return "physics";
    }

    HandlerData getData(FallingTreeEntity entity) {
        return entity.dataAnimationHandler instanceof HandlerData ? (HandlerData)entity.dataAnimationHandler : new HandlerData();
    }

    @Override
    public void initMotion(FallingTreeEntity entity) {
        entity.dataAnimationHandler = new HandlerData();
        BlockPos cutPos = entity.getDestroyData().cutPos;
        long seed = entity.field_70170_p.field_73012_v.nextLong();
        Random random = new Random(seed ^ ((long)cutPos.func_177958_n() << 32 | (long)cutPos.func_177952_p()));
        float mass = entity.getDestroyData().woodVolume.getVolume();
        float inertialMass = MathHelper.func_76131_a((float)mass, (float)1.0f, (float)3.0f);
        entity.func_213293_j(entity.func_213322_ci().field_72450_a / (double)inertialMass, entity.func_213322_ci().field_72448_b / (double)inertialMass, entity.func_213322_ci().field_72449_c / (double)inertialMass);
        this.getData((FallingTreeEntity)entity).rotPit = (random.nextFloat() - 0.5f) * 4.0f / inertialMass;
        this.getData((FallingTreeEntity)entity).rotYaw = (random.nextFloat() - 0.5f) * 4.0f / inertialMass;
        double motionToAdd = (double)entity.getDestroyData().cutDir.func_176734_d().func_82601_c() * 0.1;
        entity.func_213317_d(entity.func_213322_ci().func_72441_c(motionToAdd, motionToAdd, motionToAdd));
        FallingTreeEntity.standardDropLeavesPayLoad(entity);
    }

    @Override
    public void handleMotion(FallingTreeEntity entity) {
        if (entity.landed) {
            return;
        }
        entity.func_213293_j(entity.func_213322_ci().field_72450_a, entity.func_213322_ci().field_72448_b - (double)0.03f, entity.func_213322_ci().field_72449_c);
        entity.func_213293_j(entity.func_213322_ci().field_72450_a * (double)0.98f, entity.func_213322_ci().field_72448_b * (double)0.98f, entity.func_213322_ci().field_72449_c * (double)0.98f);
        this.getData((FallingTreeEntity)entity).rotYaw *= 0.98f;
        this.getData((FallingTreeEntity)entity).rotPit *= 0.98f;
        entity.func_70107_b(entity.func_226277_ct_() + entity.func_213322_ci().field_72450_a, entity.func_226278_cu_() + entity.func_213322_ci().field_72448_b, entity.func_226281_cx_() + entity.func_213322_ci().field_72449_c);
        entity.field_70125_A = MathHelper.func_76142_g((float)(entity.field_70125_A + this.getData((FallingTreeEntity)entity).rotPit));
        entity.field_70177_z = MathHelper.func_76142_g((float)(entity.field_70177_z + this.getData((FallingTreeEntity)entity).rotYaw));
        int radius = 8;
        if (entity.getDestroyData().getNumBranches() <= 0) {
            return;
        }
        BlockState state = entity.getDestroyData().getBranchBlockState(0);
        if (TreeHelper.isBranch(state)) {
            radius = ((BranchBlock)state.func_177230_c()).getRadius(state);
        }
        World world = entity.field_70170_p;
        AxisAlignedBB fallBox = new AxisAlignedBB(entity.func_226277_ct_() - (double)radius, entity.func_226278_cu_(), entity.func_226281_cx_() - (double)radius, entity.func_226277_ct_() + (double)radius, entity.func_226278_cu_() + 1.0, entity.func_226281_cx_() + (double)radius);
        BlockPos pos = new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        BlockState collState = world.func_180495_p(pos);
        if (!(TreeHelper.isLeaves(collState) || TreeHelper.isBranch(collState) || collState.func_177230_c() instanceof TrunkShellBlock)) {
            if (collState.func_177230_c() instanceof FlowingFluidBlock) {
                entity.func_213317_d(entity.func_213322_ci().func_72441_c(0.0, (double)0.03f, 0.0));
                entity.func_213317_d(entity.func_213322_ci().func_216372_d((double)0.8f, (double)0.8f, (double)0.8f));
                this.getData((FallingTreeEntity)entity).rotYaw *= 0.8f;
                this.getData((FallingTreeEntity)entity).rotPit *= 0.8f;
                entity.func_213317_d(entity.func_213322_ci().func_72441_c(0.0, 0.01, 0.0));
                entity.onFire = false;
            } else {
                VoxelShape shape = collState.func_196951_e((IBlockReader)world, pos);
                AxisAlignedBB collBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                if (!shape.func_197766_b()) {
                    collBox = collState.func_196951_e((IBlockReader)world, pos).func_197752_a();
                }
                if (fallBox.func_72326_a(collBox = collBox.func_186670_a(pos))) {
                    entity.func_213293_j(entity.func_213322_ci().field_72450_a, 0.0, entity.func_213322_ci().field_72449_c);
                    entity.func_70107_b(entity.func_226277_ct_(), collBox.field_72337_e, entity.func_226281_cx_());
                    entity.field_70167_r = entity.func_226278_cu_();
                    entity.landed = true;
                    entity.func_230245_c_(true);
                    if (entity.onFire && entity.field_70170_p.func_175623_d(pos.func_177984_a())) {
                        entity.field_70170_p.func_175656_a(pos.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
                    }
                }
            }
        }
    }

    @Override
    public void dropPayload(FallingTreeEntity entity) {
        World world = entity.field_70170_p;
        entity.getPayload().forEach(i -> Block.func_180635_a((World)world, (BlockPos)new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_()), (ItemStack)i));
        entity.getDestroyData().leavesDrops.forEach(bis -> Block.func_180635_a((World)world, (BlockPos)entity.getDestroyData().cutPos.func_177971_a((Vector3i)bis.pos), (ItemStack)bis.stack));
    }

    @Override
    public boolean shouldDie(FallingTreeEntity entity) {
        boolean dead;
        boolean bl = dead = entity.landed || entity.field_70173_aa > 120;
        if (dead) {
            entity.cleanupRootyDirt();
        }
        return dead;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderTransform(FallingTreeEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack) {
        float yaw = MathHelper.func_76142_g((float)com.ferreusveritas.dynamictrees.util.MathHelper.angleDegreesInterpolate(entity.field_70126_B, entity.field_70177_z, partialTicks));
        float pit = MathHelper.func_76142_g((float)com.ferreusveritas.dynamictrees.util.MathHelper.angleDegreesInterpolate(entity.field_70127_C, entity.field_70125_A, partialTicks));
        Vector3d mc = entity.getMassCenter();
        matrixStack.func_227861_a_(mc.field_72450_a, mc.field_72448_b, mc.field_72449_c);
        matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), -yaw, true));
        matrixStack.func_227863_a_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), pit, true));
        matrixStack.func_227861_a_(-mc.field_72450_a - 0.5, -mc.field_72448_b, -mc.field_72449_c - 0.5);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRender(FallingTreeEntity entity) {
        return true;
    }

    static class HandlerData
    extends DataAnimationHandler {
        float rotYaw = 0.0f;
        float rotPit = 0.0f;

        HandlerData() {
        }
    }
}

