/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.entities;

import com.ferreusveritas.dynamictrees.api.substances.SubstanceEffect;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.RootyBlock;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.systems.substances.LingeringSubstances;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.Property;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class LingeringEffectorEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private BlockPos blockPos;
    private SubstanceEffect effect;
    private byte invalidTicks = 0;

    public LingeringEffectorEntity(EntityType<? extends LingeringEffectorEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.blockPos = BlockPos.field_177992_a;
    }

    private LingeringEffectorEntity(World world) {
        super(DTRegistries.LINGERING_EFFECTOR, world);
    }

    public LingeringEffectorEntity(World world, BlockPos pos, SubstanceEffect effect) {
        this(DTRegistries.LINGERING_EFFECTOR, world);
        this.field_70138_W = 1.0f;
        this.field_70145_X = true;
        this.setBlockPos(pos);
        this.effect = effect;
        if (this.effect != null) {
            for (LingeringEffectorEntity effector : world.func_217357_a(LingeringEffectorEntity.class, new AxisAlignedBB(pos))) {
                if (effector.getEffect() == null || !effector.getEffect().getName().equals(effect.getName())) continue;
                effector.func_174812_G();
            }
        }
    }

    public static boolean treeHasEffectorForEffect(IWorld world, BlockPos pos, SubstanceEffect effect) {
        for (LingeringEffectorEntity effector : world.func_217357_a(LingeringEffectorEntity.class, new AxisAlignedBB(pos))) {
            if (effector.getEffect() == null || !effector.getEffect().getName().equals(effect.getName())) continue;
            return true;
        }
        return false;
    }

    public void setBlockPos(BlockPos pos) {
        this.blockPos = pos;
        this.func_70107_b((double)this.blockPos.func_177958_n() + 0.5, this.blockPos.func_177956_o(), (double)this.blockPos.func_177952_p() + 0.5);
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public SubstanceEffect getEffect() {
        return this.effect;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.effect == null) {
            this.invalidTicks = (byte)(this.invalidTicks + 1);
            if (this.invalidTicks > 20) {
                this.func_174812_G();
            }
            return;
        }
        BlockState blockState = this.field_70170_p.func_180495_p(this.blockPos);
        if (blockState.func_177230_c() instanceof RootyBlock) {
            if (!this.effect.update(this.field_70170_p, this.blockPos, this.field_70173_aa, (Integer)blockState.func_177229_b((Property)RootyBlock.FERTILITY))) {
                this.func_174812_G();
            }
        } else {
            this.func_174812_G();
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeByte(this.effect == null ? -1 : LingeringSubstances.indexOf(this.effect.getClass()));
    }

    public void readSpawnData(PacketBuffer additionalData) {
        byte index = additionalData.readByte();
        SubstanceEffect substanceEffect = this.effect = index < 0 ? null : (SubstanceEffect)LingeringSubstances.fromIndex(index).get();
        if (this.effect != null && this.field_70170_p != null) {
            this.effect.apply(this.field_70170_p, this.blockPos);
        }
    }
}

