/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.entities;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.branches.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.RootyBlock;
import com.ferreusveritas.dynamictrees.entities.animation.AnimationHandler;
import com.ferreusveritas.dynamictrees.entities.animation.AnimationHandlers;
import com.ferreusveritas.dynamictrees.entities.animation.DataAnimationHandler;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.models.FallingTreeEntityModelTrackerCache;
import com.ferreusveritas.dynamictrees.models.ModelTracker;
import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.ferreusveritas.dynamictrees.util.BlockStates;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class FallingTreeEntity
extends Entity
implements ModelTracker {
    public static final DataParameter<CompoundNBT> voxelDataParameter = EntityDataManager.func_187226_a(FallingTreeEntity.class, (IDataSerializer)DataSerializers.field_192734_n);
    protected List<ItemStack> payload = new ArrayList<ItemStack>(0);
    protected BranchDestructionData destroyData = new BranchDestructionData();
    protected Vector3d geomCenter = Vector3d.field_186680_a;
    protected Vector3d massCenter = Vector3d.field_186680_a;
    protected AxisAlignedBB normalBB = new AxisAlignedBB(BlockPos.field_177992_a);
    protected AxisAlignedBB cullingNormalBB = new AxisAlignedBB(BlockPos.field_177992_a);
    protected boolean clientBuilt = false;
    protected boolean firstUpdate = true;
    public boolean landed = false;
    public DestroyType destroyType = DestroyType.HARVEST;
    public boolean onFire = false;
    protected AxisAlignedBB cullingBB;
    public static AnimationHandler AnimHandlerFall = AnimationHandlers.falloverAnimationHandler;
    public static AnimationHandler AnimHandlerDrop = AnimationHandlers.defaultAnimationHandler;
    public static AnimationHandler AnimHandlerBurn = AnimationHandlers.defaultAnimationHandler;
    public static AnimationHandler AnimHandlerFling = AnimationHandlers.defaultAnimationHandler;
    public static AnimationHandler AnimHandlerBlast = AnimationHandlers.blastAnimationHandler;
    public AnimationHandler currentAnimationHandler = AnimationHandlers.voidAnimationHandler;
    public DataAnimationHandler dataAnimationHandler = null;

    public FallingTreeEntity(World world) {
        super(DTRegistries.FALLING_TREE, world);
    }

    public FallingTreeEntity(EntityType<? extends FallingTreeEntity> type, World world) {
        super(type, world);
    }

    public boolean isClientBuilt() {
        return this.clientBuilt;
    }

    public FallingTreeEntity setData(BranchDestructionData destroyData, List<ItemStack> payload, DestroyType destroyType) {
        this.destroyData = destroyData;
        if (destroyData.getNumBranches() == 0) {
            System.err.println("Warning: Tried to create a EntityFallingTree with no branch blocks. This shouldn't be possible.");
            new Exception().printStackTrace();
            this.func_174812_G();
            return this;
        }
        BlockPos cutPos = destroyData.cutPos;
        this.payload = payload;
        this.destroyType = destroyType;
        this.onFire = destroyType == DestroyType.FIRE;
        this.func_226288_n_((double)cutPos.func_177958_n() + 0.5, cutPos.func_177956_o(), (double)cutPos.func_177952_p() + 0.5);
        int numBlocks = destroyData.getNumBranches();
        this.geomCenter = new Vector3d(0.0, 0.0, 0.0);
        double totalMass = 0.0;
        for (int index = 0; index < destroyData.getNumBranches(); ++index) {
            BlockPos relPos = destroyData.getBranchRelPos(index);
            int radius = destroyData.getBranchRadius(index);
            float mass = (float)(radius * radius * 64) / 4096.0f;
            totalMass += (double)mass;
            Vector3d relVec = new Vector3d((double)relPos.func_177958_n(), (double)relPos.func_177956_o(), (double)relPos.func_177952_p());
            this.geomCenter = this.geomCenter.func_178787_e(relVec);
            this.massCenter = this.massCenter.func_178787_e(relVec.func_186678_a((double)mass));
        }
        this.geomCenter = this.geomCenter.func_186678_a(1.0 / (double)numBlocks);
        this.massCenter = this.massCenter.func_186678_a(1.0 / totalMass);
        this.setVoxelData(this.buildVoxelData(destroyData));
        return this;
    }

    public CompoundNBT buildVoxelData(BranchDestructionData destroyData) {
        CompoundNBT tag = new CompoundNBT();
        destroyData.writeToNBT(tag);
        tag.func_74780_a("geomx", this.geomCenter.field_72450_a);
        tag.func_74780_a("geomy", this.geomCenter.field_72448_b);
        tag.func_74780_a("geomz", this.geomCenter.field_72449_c);
        tag.func_74780_a("massx", this.massCenter.field_72450_a);
        tag.func_74780_a("massy", this.massCenter.field_72448_b);
        tag.func_74780_a("massz", this.massCenter.field_72449_c);
        tag.func_74768_a("destroytype", this.destroyType.ordinal());
        tag.func_74757_a("onfire", this.onFire);
        return tag;
    }

    public void setupFromNBT(CompoundNBT tag) {
        this.destroyData = new BranchDestructionData(tag);
        if (this.destroyData.getNumBranches() == 0) {
            this.func_174812_G();
        }
        this.destroyType = DestroyType.values()[tag.func_74762_e("destroytype")];
        this.geomCenter = new Vector3d(tag.func_74769_h("geomx"), tag.func_74769_h("geomy"), tag.func_74769_h("geomz"));
        this.massCenter = new Vector3d(tag.func_74769_h("massx"), tag.func_74769_h("massy"), tag.func_74769_h("massz"));
        this.func_174826_a(this.buildAABBFromDestroyData(this.destroyData).func_72317_d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()));
        this.cullingBB = this.cullingNormalBB.func_72317_d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        this.onFire = tag.func_74767_n("onfire");
    }

    public void buildClient() {
        CompoundNBT tag = this.getVoxelData();
        if (tag.func_74764_b("species")) {
            this.setupFromNBT(tag);
            this.clientBuilt = true;
        } else {
            System.out.println("Error: No species tag has been set");
        }
        BlockBounds renderBounds = new BlockBounds(this.destroyData.cutPos);
        for (BlockPos absPos : Iterables.concat(this.destroyData.getPositions(BranchDestructionData.PosType.BRANCHES), this.destroyData.getPositions(BranchDestructionData.PosType.LEAVES))) {
            BlockState state = this.field_70170_p.func_180495_p(absPos);
            if (!TreeHelper.isTreePart(state)) continue;
            this.field_70170_p.func_180501_a(absPos, BlockStates.AIR, 0);
            renderBounds.union(absPos);
        }
        this.cleanupShellBlocks(this.destroyData);
        Minecraft.func_71410_x().field_71438_f.func_147585_a(renderBounds.getMin().func_177958_n(), renderBounds.getMin().func_177956_o(), renderBounds.getMin().func_177952_p(), renderBounds.getMax().func_177958_n(), renderBounds.getMax().func_177956_o(), renderBounds.getMax().func_177952_p());
    }

    protected void cleanupShellBlocks(BranchDestructionData destroyData) {
        BlockPos cutPos = destroyData.cutPos;
        for (int i = 0; i < destroyData.getNumBranches(); ++i) {
            if (destroyData.getBranchRadius(i) <= 8) continue;
            BlockPos pos = destroyData.getBranchRelPos(i).func_177971_a((Vector3i)cutPos);
            for (CoordUtils.Surround dir : CoordUtils.Surround.values()) {
                BlockPos dPos = pos.func_177971_a(dir.getOffset());
                if (!(this.field_70170_p.func_180495_p(dPos).func_177230_c() instanceof TrunkShellBlock)) continue;
                this.field_70170_p.func_217377_a(dPos, false);
            }
        }
    }

    public AxisAlignedBB buildAABBFromDestroyData(BranchDestructionData destroyData) {
        this.normalBB = new AxisAlignedBB(BlockPos.field_177992_a);
        for (BlockPos relPos : destroyData.getPositions(BranchDestructionData.PosType.BRANCHES, false)) {
            this.normalBB = this.normalBB.func_111270_a(new AxisAlignedBB(relPos));
        }
        double height = this.normalBB.field_72337_e - this.normalBB.field_72338_b;
        double width = MathHelper.func_76132_a((double)(this.normalBB.field_72336_d - this.normalBB.field_72340_a), (double)(this.normalBB.field_72334_f - this.normalBB.field_72339_c));
        double grow = Math.max(0.0, height - width / 2.0) + 2.0;
        this.cullingNormalBB = this.normalBB.func_72314_b(grow + 4.0, 4.0, grow + 4.0);
        return this.normalBB;
    }

    public AxisAlignedBB func_184177_bl() {
        return this.cullingBB;
    }

    public BranchDestructionData getDestroyData() {
        return this.destroyData;
    }

    public List<ItemStack> getPayload() {
        return this.payload;
    }

    public Vector3d getGeomCenter() {
        return this.geomCenter;
    }

    public Vector3d getMassCenter() {
        return this.massCenter;
    }

    public void func_70107_b(double x, double y, double z) {
        this.func_226288_n_(x, y, z);
        this.func_174826_a(this.normalBB != null ? this.normalBB.func_72317_d(x, y, z) : new AxisAlignedBB(BlockPos.field_177992_a));
        this.cullingBB = this.cullingNormalBB != null ? this.cullingNormalBB.func_72317_d(x, y, z) : new AxisAlignedBB(BlockPos.field_177992_a);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && !this.clientBuilt) {
            this.buildClient();
            if (!this.func_70089_S()) {
                return;
            }
        }
        if (!this.field_70170_p.field_72995_K && this.firstUpdate) {
            this.updateNeighbors();
        }
        this.handleMotion();
        this.func_174826_a(this.normalBB.func_72317_d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()));
        this.cullingBB = this.cullingNormalBB.func_72317_d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        if (this.shouldDie()) {
            this.dropPayLoad();
            this.func_174812_G();
            this.modelCleanup();
        }
        this.firstUpdate = false;
    }

    protected void updateNeighbors() {
        HashSet destroyed = new HashSet();
        HashSet<BlockPos> toUpdate = new HashSet<BlockPos>();
        Iterables.concat(this.destroyData.getPositions(BranchDestructionData.PosType.BRANCHES), this.destroyData.getPositions(BranchDestructionData.PosType.LEAVES)).forEach(destroyed::add);
        for (BlockPos d : destroyed) {
            for (Direction dir : Direction.values()) {
                BlockPos dPos = d.func_177972_a(dir);
                if (destroyed.contains(dPos)) continue;
                toUpdate.add(dPos);
            }
        }
        toUpdate.forEach(pos -> this.field_70170_p.func_190524_a(pos, Blocks.field_150350_a, pos));
    }

    protected AnimationHandler selectAnimationHandler() {
        return (Boolean)DTConfigs.ENABLE_FALLING_TREES.get() != false ? this.destroyData.species.selectAnimationHandler(this) : AnimationHandlers.voidAnimationHandler;
    }

    public AnimationHandler defaultAnimationHandler() {
        if (this.destroyType == DestroyType.VOID || this.destroyType == DestroyType.ROOT) {
            return AnimationHandlers.voidAnimationHandler;
        }
        if (this.destroyType == DestroyType.BLAST) {
            return AnimHandlerBlast;
        }
        if (this.destroyType == DestroyType.FIRE) {
            return AnimHandlerBurn;
        }
        if (this.getDestroyData().cutDir == Direction.DOWN) {
            if (this.getMassCenter().field_72448_b >= 1.0) {
                return AnimHandlerFall;
            }
            return AnimHandlerFling;
        }
        return AnimHandlerDrop;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void modelCleanup() {
        FallingTreeEntityModelTrackerCache.cleanupModels(this.field_70170_p, this);
    }

    public void handleMotion() {
        if (this.firstUpdate) {
            this.currentAnimationHandler = this.selectAnimationHandler();
            this.currentAnimationHandler.initMotion(this);
        } else {
            this.currentAnimationHandler.handleMotion(this);
        }
    }

    public void dropPayLoad() {
        if (!this.field_70170_p.field_72995_K) {
            this.currentAnimationHandler.dropPayload(this);
        }
    }

    public boolean shouldDie() {
        return this.field_70173_aa > 20 && this.currentAnimationHandler.shouldDie(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRender() {
        return this.currentAnimationHandler.shouldRender(this);
    }

    public static void standardDropLogsPayload(FallingTreeEntity entity) {
        World world = entity.field_70170_p;
        if (!world.field_72995_K) {
            BlockPos cutPos = entity.getDestroyData().cutPos;
            entity.getPayload().forEach(i -> FallingTreeEntity.spawnItemAsEntity(world, cutPos, i));
        }
    }

    public static void standardDropLeavesPayLoad(FallingTreeEntity entity) {
        World world = entity.field_70170_p;
        if (!world.field_72995_K) {
            BlockPos cutPos = entity.getDestroyData().cutPos;
            entity.getDestroyData().leavesDrops.forEach(bis -> Block.func_180635_a((World)world, (BlockPos)cutPos.func_177971_a((Vector3i)bis.pos), (ItemStack)bis.stack));
        }
    }

    public static void spawnItemAsEntity(World worldIn, BlockPos pos, ItemStack stack) {
        if (!worldIn.field_72995_K && !stack.func_190926_b() && worldIn.func_82736_K().func_223586_b(GameRules.field_223603_f) && !worldIn.restoringBlockSnapshots) {
            ItemEntity entityitem = new ItemEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
            entityitem.func_213293_j(0.0, 0.0, 0.0);
            entityitem.func_174869_p();
            worldIn.func_217376_c((Entity)entityitem);
        }
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(voxelDataParameter, (Object)new CompoundNBT());
    }

    public void cleanupRootyDirt() {
        BlockPos rootPos;
        BlockState belowState;
        if (!this.field_70170_p.field_72995_K && TreeHelper.isRooty(belowState = this.field_70170_p.func_180495_p(rootPos = this.getDestroyData().cutPos.func_177977_b()))) {
            RootyBlock rootyBlock = (RootyBlock)belowState.func_177230_c();
            rootyBlock.doDecay(this.field_70170_p, rootPos, belowState, this.getDestroyData().species);
        }
    }

    public void setVoxelData(CompoundNBT tag) {
        this.func_174826_a(this.buildAABBFromDestroyData(this.destroyData).func_72317_d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()));
        this.cullingBB = this.cullingNormalBB.func_72317_d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        this.func_184212_Q().func_187227_b(voxelDataParameter, (Object)tag);
    }

    public CompoundNBT getVoxelData() {
        return (CompoundNBT)this.func_184212_Q().func_187225_a(voxelDataParameter);
    }

    protected void func_70037_a(CompoundNBT compound) {
        CompoundNBT vox = (CompoundNBT)compound.func_74781_a("vox");
        this.setupFromNBT(vox);
        this.setVoxelData(vox);
        if (compound.func_74764_b("payload")) {
            ListNBT nbtList = (ListNBT)compound.func_74781_a("payload");
            for (INBT tag : Objects.requireNonNull(nbtList)) {
                if (!(tag instanceof CompoundNBT)) continue;
                CompoundNBT compTag = (CompoundNBT)tag;
                this.payload.add(ItemStack.func_199557_a((CompoundNBT)compTag));
            }
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_218657_a("vox", (INBT)this.getVoxelData());
        if (!this.payload.isEmpty()) {
            ListNBT list = new ListNBT();
            for (ItemStack stack : this.payload) {
                list.add((Object)stack.serializeNBT());
            }
            compound.func_218657_a("payload", (INBT)list);
        }
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static FallingTreeEntity dropTree(World world, BranchDestructionData destroyData, List<ItemStack> woodDropList, DestroyType destroyType) {
        if (!world.field_72995_K) {
            FallingTreeEntity entity = new FallingTreeEntity(world).setData(destroyData, woodDropList, destroyType);
            if (entity.func_70089_S()) {
                world.func_217376_c((Entity)entity);
            }
            return entity;
        }
        return null;
    }

    public static enum DestroyType {
        VOID,
        HARVEST,
        BLAST,
        FIRE,
        ROOT;

    }
}

