/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.deserialisation;

import com.ferreusveritas.dynamictrees.deserialisation.DeserialisationException;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.deserialisation.JsonHelper;
import com.ferreusveritas.dynamictrees.deserialisation.result.JsonResult;
import com.ferreusveritas.dynamictrees.deserialisation.result.Result;
import com.ferreusveritas.dynamictrees.util.CommonVoxelShapes;
import com.ferreusveritas.dynamictrees.util.ShapeFunctions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public final class VoxelShapeDeserialiser
implements JsonDeserialiser<VoxelShape> {
    @Override
    public Result<VoxelShape, JsonElement> deserialise(JsonElement input) {
        return JsonResult.forInput(input).mapIfType(String.class, name -> CommonVoxelShapes.SHAPES.getOrDefault(name.toLowerCase(), VoxelShapes.func_197868_b())).elseMapIfType(AxisAlignedBB.class, VoxelShapes::func_197881_a).elseMapIfType(JsonArray.class, this::deserialiseArray).elseMapIfType(JsonObject.class, this::deserialiseObject).elseTypeError();
    }

    private VoxelShape deserialiseArray(JsonArray array) throws DeserialisationException {
        VoxelShape shape = VoxelShapes.func_197880_a();
        for (JsonElement element : array) {
            shape = VoxelShapes.func_216384_a((VoxelShape)((VoxelShape)JsonDeserialisers.AXIS_ALIGNED_BB.deserialise(element).map(VoxelShapes::func_197881_a).orElseThrow()), (VoxelShape[])new VoxelShape[0]);
        }
        return shape;
    }

    private VoxelShape deserialiseObject(JsonObject json) throws DeserialisationException {
        return (VoxelShape)JsonResult.forInput((JsonElement)json).mapIfContains("function", String.class, functionId -> (VoxelShape)ShapeFunctions.calculateShape(functionId, (JsonElement)this.getParametersJson(json)).getOrThrow(true, s -> {})).elseMapIfContains("shapes", JsonArray.class, shapes -> {
            IBooleanFunction operator = JsonHelper.getOrDefault(json, "operator", IBooleanFunction.class, IBooleanFunction.field_223244_o_);
            return this.deserialiseShapes(operator, (JsonArray)shapes);
        }).elseTypeError().orElseThrow();
    }

    private JsonObject getParametersJson(JsonObject json) {
        return JsonHelper.getOrDefault(json, "parameters", JsonObject.class, new JsonObject());
    }

    private VoxelShape deserialiseShapes(IBooleanFunction operator, JsonArray shapes) throws DeserialisationException {
        if (shapes.size() < 1) {
            return VoxelShapes.func_197880_a();
        }
        VoxelShape shape = this.deserialise(shapes.get(0)).orElseThrow();
        for (int i = 1; i < shapes.size(); ++i) {
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)this.deserialise(shapes.get(i)).orElseThrow(), (IBooleanFunction)operator);
        }
        return shape;
    }
}

